/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.amazon.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.modules.amazon.adapters.SQSConnectorConnectionIdentifierAdapter;
import org.mule.modules.amazon.connectivity.SQSConnectorConnectionKey;
import org.mule.modules.amazon.connectivity.SQSConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQSConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(SQSConnectorConnectionFactory.class);
    private SQSConnectorConnectionManager connectionManager;

    public SQSConnectorConnectionFactory(SQSConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof SQSConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        SQSConnectorConnectionIdentifierAdapter connector = new SQSConnectorConnectionIdentifierAdapter();
        connector.setAccessKey(this.connectionManager.getAccessKey());
        connector.setSecretAccessKey(this.connectionManager.getSecretAccessKey());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SQSConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SQSConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((SQSConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((SQSConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((SQSConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof SQSConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((SQSConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SQSConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SQSConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((SQSConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((SQSConnectorConnectionIdentifierAdapter)obj).connect(((SQSConnectorConnectionKey)key).getQueueName());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

