/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.amazon.config;

import org.mule.config.PoolingProfile;
import org.mule.modules.amazon.config.AbstractDefinitionParser;
import org.mule.modules.amazon.connectivity.SQSConnectorConnectionManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SQSConnectorConfigDefinitionParser
extends AbstractDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)SQSConnectorConnectionManager.class.getName());
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, SQSConnectorConnectionManager.class);
        this.setDestroyMethodIfNeeded(builder, SQSConnectorConnectionManager.class);
        this.parseProperty(builder, element, "accessKey", "accessKey");
        this.parseProperty(builder, element, "secretAccessKey", "secretAccessKey");
        this.parseProperty(builder, element, "queueName", "queueName");
        BeanDefinitionBuilder connectionPoolingProfileBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PoolingProfile.class.getName());
        Element connectionPoolingProfileElement = DomUtils.getChildElementByTagName((Element)element, (String)"connection-pooling-profile");
        if (connectionPoolingProfileElement != null) {
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxActive");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxIdle");
            this.parseProperty(connectionPoolingProfileBuilder, connectionPoolingProfileElement, "maxWait");
            if (this.hasAttribute(connectionPoolingProfileElement, "exhaustedAction")) {
                connectionPoolingProfileBuilder.addPropertyValue("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS.get(connectionPoolingProfileElement.getAttribute("exhaustedAction")));
            }
            if (this.hasAttribute(connectionPoolingProfileElement, "initialisationPolicy")) {
                connectionPoolingProfileBuilder.addPropertyValue("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES.get(connectionPoolingProfileElement.getAttribute("initialisationPolicy")));
            }
            builder.addPropertyValue("connectionPoolingProfile", (Object)connectionPoolingProfileBuilder.getBeanDefinition());
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-forever", element, parserContext, builder, (BeanDefinition)definition);
        this.parseRetryPolicyTemplate("reconnect-custom-strategy", element, parserContext, builder, (BeanDefinition)definition);
        return definition;
    }
}

