/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.amazon;

import com.xerox.amazonws.sqs2.Message;
import com.xerox.amazonws.sqs2.MessageQueue;
import com.xerox.amazonws.sqs2.QueueAttribute;
import com.xerox.amazonws.sqs2.SQSException;
import com.xerox.amazonws.sqs2.SQSUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.callback.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Connector(name="sqs")
public class SQSConnector {
    private static Logger logger = LoggerFactory.getLogger(SQSConnector.class);
    @Configurable
    private String accessKey;
    @Configurable
    private String secretAccessKey;
    private MessageQueue msgQueue;

    @Connect
    public void connect(@ConnectionKey String queueName) throws ConnectionException {
        try {
            this.msgQueue = SQSUtils.connectToQueue((String)queueName, (String)this.accessKey, (String)this.secretAccessKey);
            this.msgQueue.setEncoding(false);
        }
        catch (SQSException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage(), (Throwable)e);
        }
    }

    @Disconnect
    public void disconnect() {
        this.msgQueue = null;
    }

    @ValidateConnection
    public boolean isConnected() {
        return this.msgQueue != null;
    }

    @ConnectionIdentifier
    public String getMessageQueueUrl() {
        return this.msgQueue.getUrl().toString();
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public void sendMessage(@Optional @Default(value="#[payload]") String message) throws SQSException {
        this.msgQueue.sendMessage(message);
    }

    @Processor
    public URL getUrl() {
        return this.msgQueue.getUrl();
    }

    @Source
    @InvalidateConnectionOn(exception=SQSException.class)
    public void receiveMessages(SourceCallback callback, @Optional @Default(value="30") Integer visibilityTimeout, @Optional @Default(value="false") Boolean preserveMessages, @Optional @Default(value="1000") Long pollPeriod, @Optional @Default(value="1") Integer numberOfMessages) throws SQSException {
        while (!Thread.interrupted()) {
            Message[] messages = visibilityTimeout == null ? this.msgQueue.receiveMessages(numberOfMessages.intValue()) : this.msgQueue.receiveMessages(numberOfMessages.intValue(), visibilityTimeout.intValue());
            try {
                if (messages.length == 0) {
                    Thread.sleep(pollPeriod);
                    continue;
                }
                for (Message msg : messages) {
                    callback.process((Object)msg.getMessageBody(), this.createProperties(msg));
                    if (preserveMessages.booleanValue()) continue;
                    this.msgQueue.deleteMessage(msg);
                }
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new SQSException("Error while processing message.", e);
            }
        }
    }

    public Map<String, Object> createProperties(Message msg) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(msg.getAttributes());
        properties.put("sqs.message.id", msg.getMessageId());
        properties.put("sqs.message.receipt.handle", msg.getReceiptHandle());
        return properties;
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public void deleteMessage(@Optional @Default(value="#[header:inbound:sqs.message.receipt.handle]") String receiptHandle) throws SQSException {
        this.msgQueue.deleteMessage(receiptHandle);
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public void deleteQueue() throws SQSException {
        this.msgQueue.deleteQueue();
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public Map<String, String> getQueueAttributes(QueueAttribute attribute) throws SQSException {
        return this.msgQueue.getQueueAttributes(attribute);
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public void setQueueAttribute(QueueAttribute attribute, String value) throws SQSException {
        this.msgQueue.setQueueAttribute(attribute.name(), value);
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public void addPermission(String label, String accountId, String action) throws SQSException {
        this.msgQueue.addPermission(label, accountId, action);
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public void removePermission(String label) throws SQSException {
        this.msgQueue.removePermission(label);
    }

    @Processor
    @InvalidateConnectionOn(exception=SQSException.class)
    public int getApproximateNumberOfMessages() throws SQSException {
        return this.msgQueue.getApproximateNumberOfMessages();
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }
}

