
package org.mule.modules.amazon.sources;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.callback.SourceCallback;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.source.MessageSource;
import org.mule.modules.amazon.SQSConnector;
import org.mule.modules.amazon.connectivity.SQSConnectorConnectionManager;
import org.mule.modules.amazon.processors.AbstractListeningMessageProcessor;


/**
 * ReceiveMessagesMessageSource wraps {@link org.mule.modules.amazon.SQSConnector#receiveMessages(org.mule.api.callback.SourceCallback, java.lang.Integer, java.lang.Boolean, java.lang.Long, java.lang.Integer)} method in {@link SQSConnector } as a message source capable of generating Mule events.  The POJO's method is invoked in its own thread.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.1", date = "2012-09-04T06:40:29-03:00", comments = "Build UNNAMED.1292.1980b66")
public class ReceiveMessagesMessageSource
    extends AbstractListeningMessageProcessor<Object>
    implements Runnable, FlowConstructAware, MuleContextAware, Startable, Stoppable, MessageSource
{

    protected Object visibilityTimeout;
    protected Integer _visibilityTimeoutType;
    protected Object preserveMessages;
    protected Boolean _preserveMessagesType;
    protected Object pollPeriod;
    protected Long _pollPeriodType;
    protected Object numberOfMessages;
    protected Integer _numberOfMessagesType;
    protected Object queueName;
    protected String _queueNameType;
    /**
     * Thread under which this message source will execute
     * 
     */
    private Thread thread;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    /**
     * Sets visibilityTimeout
     * 
     * @param value Value to set
     */
    public void setVisibilityTimeout(Object value) {
        this.visibilityTimeout = value;
    }

    /**
     * Sets pollPeriod
     * 
     * @param value Value to set
     */
    public void setPollPeriod(Object value) {
        this.pollPeriod = value;
    }

    /**
     * Sets preserveMessages
     * 
     * @param value Value to set
     */
    public void setPreserveMessages(Object value) {
        this.preserveMessages = value;
    }

    /**
     * Sets numberOfMessages
     * 
     * @param value Value to set
     */
    public void setNumberOfMessages(Object value) {
        this.numberOfMessages = value;
    }

    /**
     * Sets queueName
     * 
     * @param value Value to set
     */
    public void setQueueName(Object value) {
        this.queueName = value;
    }

    /**
     * Method to be called when Mule instance gets started.
     * 
     */
    public void start()
        throws MuleException
    {
        if (thread == null) {
            thread = new Thread(this, "Receiving Thread");
        }
        thread.start();
    }

    /**
     * Method to be called when Mule instance gets stopped.
     * 
     */
    public void stop()
        throws MuleException
    {
        thread.interrupt();
    }

    /**
     * Implementation {@link Runnable#run()} that will invoke the method on the pojo that this message source wraps.
     * 
     */
    public void run() {
        try {
            findOrCreate(SQSConnectorConnectionManager.class, false, null);
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) getModuleObject()).getProcessTemplate();
            final SourceCallback sourceCallback = this;
            final Integer transformedVisibilityTimeout = ((Integer) transform(getMuleContext(), null, getClass().getDeclaredField("_visibilityTimeoutType").getGenericType(), null, visibilityTimeout));
            final Boolean transformedPreserveMessages = ((Boolean) transform(getMuleContext(), null, getClass().getDeclaredField("_preserveMessagesType").getGenericType(), null, preserveMessages));
            final Long transformedPollPeriod = ((Long) transform(getMuleContext(), null, getClass().getDeclaredField("_pollPeriodType").getGenericType(), null, pollPeriod));
            final Integer transformedNumberOfMessages = ((Integer) transform(getMuleContext(), null, getClass().getDeclaredField("_numberOfMessagesType").getGenericType(), null, numberOfMessages));
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((SQSConnector) object).receiveMessages(sourceCallback, transformedVisibilityTimeout, transformedPreserveMessages, transformedPollPeriod, transformedNumberOfMessages);
                    return null;
                }

            }
            , null, null);
        } catch (MessagingException e) {
            getFlowConstruct().getExceptionListener().handleException(e, e.getEvent());
        } catch (Exception e) {
            getMuleContext().getExceptionListener().handleException(e);
        }
    }

}
