
package org.mule.modules.amazon.config;

import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.modules.amazon.sources.ReceiveMessagesMessageSource;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ReceiveMessagesDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ReceiveMessagesDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReceiveMessagesMessageSource.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("visibilityTimeout")!= null)&&(!StringUtils.isBlank(element.getAttribute("visibilityTimeout")))) {
            builder.addPropertyValue("visibilityTimeout", element.getAttribute("visibilityTimeout"));
        }
        if ((element.getAttribute("preserveMessages")!= null)&&(!StringUtils.isBlank(element.getAttribute("preserveMessages")))) {
            builder.addPropertyValue("preserveMessages", element.getAttribute("preserveMessages"));
        }
        if ((element.getAttribute("pollPeriod")!= null)&&(!StringUtils.isBlank(element.getAttribute("pollPeriod")))) {
            builder.addPropertyValue("pollPeriod", element.getAttribute("pollPeriod"));
        }
        if ((element.getAttribute("numberOfMessages")!= null)&&(!StringUtils.isBlank(element.getAttribute("numberOfMessages")))) {
            builder.addPropertyValue("numberOfMessages", element.getAttribute("numberOfMessages"));
        }
        if ((element.getAttribute("retryMax")!= null)&&(!StringUtils.isBlank(element.getAttribute("retryMax")))) {
            builder.addPropertyValue("retryMax", element.getAttribute("retryMax"));
        }
        if ((element.getAttribute("queueName")!= null)&&(!StringUtils.isBlank(element.getAttribute("queueName")))) {
            builder.addPropertyValue("queueName", element.getAttribute("queueName"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        propertyValues.addPropertyValue("messageSource", definition);
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
