/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.tests;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.mina.core.RuntimeIoException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.model.InitializationError;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.Result;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.construct.Flow;
import org.mule.modules.tests.exceptions.GlobalElementNotFoundException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorTestCase
extends FunctionalTestCase {
    private static final String AUTOMATION_CREDENTIALS_BEAN_NOT_FOUND = "automationCredentials bean not found. Check that ConnectorTestCaseSpringBeans.xml was imported to AutomationSpringBeans.xml.";
    private static final Logger LOGGER = Logger.getLogger(ConnectorTestCase.class);
    protected static final String DEFAULT_SPRING_CONFIG_FILE = "AutomationSpringBeans.xml";
    protected static List<String> SPRING_CONFIG_FILES = new LinkedList<String>();
    private static final String SPRINGBEANS_NOT_INITIALIZED = "Problem loading Spring beans file, couldn't create the context for ConnectorTestParent.";
    private static final String TEST_FLOWS_FILE_NOT_FOUND = "Test flows xml file was not found.";
    private static final String MALFORMED_TEST_FLOWS_FILE = "Test flows xml is not well formed.";
    private static final String TESTRUNMESSAGE_NOT_INITIALIZED = "TestRunMessage was not initialized for current test.";
    private static final String FLOW_NOT_FOUND = "Flow not found on flow file.";
    private static final String BEAN_NOT_FOUND = "Bean not found on Spring beans file.";
    private Map<String, Object> testData = null;
    private static ApplicationContext context;
    protected static Properties automationCredentials;
    private static List<String> testFlowsNames;

    protected static void loadTestFlows(String configResources) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document testFlowsDocument = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configResources);
            testFlowsDocument = documentBuilder.parse(dataStream);
        }
        catch (IOException e) {
            throw new RuntimeIoException(TEST_FLOWS_FILE_NOT_FOUND);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeIoException(MALFORMED_TEST_FLOWS_FILE);
        }
        catch (SAXException e) {
            throw new RuntimeException();
        }
        NodeList flowsList = testFlowsDocument.getElementsByTagName("flow");
        for (int flowIndex = 0; flowIndex < flowsList.getLength(); ++flowIndex) {
            Node flow = flowsList.item(flowIndex);
            if (flow.getNodeType() != 1) continue;
            Element flowElement = (Element)flow;
            testFlowsNames.add(flowElement.getAttribute("name"));
        }
    }

    private static void initializeSpringApplicationContext() throws BeansException {
        SPRING_CONFIG_FILES.add(DEFAULT_SPRING_CONFIG_FILE);
        context = new ClassPathXmlApplicationContext(ConnectorTestCase.getConfigSpringFiles());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        try {
            ConnectorTestCase.initializeSpringApplicationContext();
        }
        catch (BeansException e) {
            throw new Exception(String.format("%s\n%s", SPRINGBEANS_NOT_INITIALIZED, e.getMessage()));
        }
    }

    @Before
    public final void clearTestData() {
        this.testData = null;
    }

    protected static String[] getConfigSpringFiles() {
        return SPRING_CONFIG_FILES.toArray(new String[SPRING_CONFIG_FILES.size()]);
    }

    protected static void addConfigSpringFile(String fileLocation) {
        SPRING_CONFIG_FILES.add(fileLocation);
    }

    protected static void setConfigSpringFiles(List<String> configFilesLocation) {
        SPRING_CONFIG_FILES = configFilesLocation;
    }

    protected String getConfigResources() {
        String configXmlFile = this.getConfigXmlFile();
        ConnectorTestCase.loadTestFlows(configXmlFile);
        return configXmlFile;
    }

    protected String getConfigXmlFile() {
        return "automation-test-flows.xml";
    }

    private void verifyValidFlowName(String flowName) throws Exception {
        if (!testFlowsNames.contains(flowName)) {
            throw new Exception(FLOW_NOT_FOUND);
        }
    }

    private void verifyValidBeanId(String beanId) throws Exception {
        if (!context.containsBean(beanId)) {
            throw new Exception(BEAN_NOT_FOUND);
        }
    }

    private void preInvokationVerifications(String flowName, String ... beanId) throws Exception {
        this.verifyTestRunMessageIsInitialized();
        this.verifyValidFlowName(flowName);
        if (beanId.length > 0) {
            this.verifyValidBeanId(beanId[0]);
        }
    }

    protected void verifyTestRunMessageIsInitialized() throws Exception {
        if (this.testData == null) {
            throw new InitializationError(TESTRUNMESSAGE_NOT_INITIALIZED);
        }
    }

    private MuleEvent generateMuleEvent() throws Exception {
        Object payload = null;
        Boolean hasPayloadContent = this.testData.containsKey("payloadContent");
        if (hasPayloadContent.booleanValue()) {
            payload = this.testData.get("payloadContent");
        }
        MuleEvent event = ConnectorTestCase.getTestEvent(payload);
        for (String key : this.testData.keySet()) {
            if (key.equals("payloadContent")) continue;
            event.setFlowVariable(key, this.testData.get(key));
        }
        return event;
    }

    private MuleEvent generateMuleEvent(String beanId) throws Exception {
        Object payload = null;
        HashMap operationAttributesValues = new HashMap();
        Object bean = context.getBean(beanId);
        if (bean instanceof Map && beanId.endsWith("TestData")) {
            operationAttributesValues = (HashMap)bean;
        } else {
            payload = bean;
        }
        Boolean hasPayloadContent = operationAttributesValues.containsKey("payloadContent");
        if (hasPayloadContent.booleanValue()) {
            payload = operationAttributesValues.get("payloadContent");
        }
        MuleEvent event = ConnectorTestCase.getTestEvent((Object)payload);
        for (String key : operationAttributesValues.keySet()) {
            if (key.equals("payloadContent")) continue;
            event.setFlowVariable(key, operationAttributesValues.get(key));
        }
        return event;
    }

    protected Flow lookupFlowConstruct(String name) {
        Flow flow = null;
        try {
            flow = (Flow)muleContext.getRegistry().lookupFlowConstruct(name);
        }
        catch (Exception e) {
            LOGGER.fatal((Object)e.getMessage());
        }
        return flow;
    }

    @Deprecated
    protected void loadTestRunMessage(String beanId) {
        Object bean = context.getBean(beanId);
        this.testData.clear();
        if (bean instanceof Map) {
            this.testData.putAll((Map)context.getBean(beanId));
        } else {
            this.testData.put(beanId, bean);
        }
    }

    @Deprecated
    public void loadTestRunMessage(Map<String, Object> data) {
        this.testData.clear();
        this.testData.putAll(data);
    }

    protected void initializeTestRunMessage() {
        this.testData = new HashMap<String, Object>();
    }

    protected void initializeTestRunMessage(String beanId) {
        this.testData = new HashMap<String, Object>();
        Object bean = context.getBean(beanId);
        if (bean instanceof Map && beanId.endsWith("TestData")) {
            this.testData.putAll((Map)context.getBean(beanId));
        } else {
            this.testData.put("payloadContent", bean);
        }
    }

    public void initializeTestRunMessage(String key, Object value) {
        this.testData = new HashMap<String, Object>();
        this.testData.put(key, value);
    }

    public void initializeTestRunMessage(Object data) {
        this.testData = new HashMap<String, Object>();
        if (data instanceof Map) {
            this.testData.putAll((Map)data);
        } else {
            this.testData.put("payloadContent", data);
        }
    }

    public <T> T getBeanFromContext(String beanId) throws BeansException {
        return (T)context.getBean(beanId);
    }

    public void upsertBeanFromContextOnTestRunMessage(String beanId) {
        Object bean = this.getBeanFromContext(beanId);
        if (bean instanceof Map) {
            this.testData.putAll((Map)context.getBean(beanId));
        } else {
            this.testData.put("payloadContent", bean);
        }
    }

    public void upsertBeanFromContextOnTestRunMessage(String key, String beanId) {
        Object bean = this.getBeanFromContext(beanId);
        this.testData.put(key, bean);
    }

    public void upsertOnTestRunMessage(String key, Object value) {
        this.testData.put(key, value);
    }

    public void upsertOnTestRunMessage(Map<String, Object> data) {
        this.testData.putAll(data);
    }

    public void upsertPayloadContentOnTestRunMessage(Object payloadContent) {
        this.upsertOnTestRunMessage("payloadContent", payloadContent);
    }

    public <T> T getTestRunMessagePayload() {
        Object payloadContent = null;
        if (this.testData.containsKey("payloadContent")) {
            payloadContent = this.testData.get("payloadContent");
        }
        return (T)payloadContent;
    }

    public <T> T getTestRunMessageValue(String key) {
        return (T)this.testData.get(key);
    }

    public void removeFromTestRunMessage(String key) {
        this.testData.remove(key);
    }

    public boolean keyContainedInTestRunMessage(Object key) {
        return this.testData.containsKey(key);
    }

    public Set<String> getTestRunMessageKeySet() {
        return this.testData.keySet();
    }

    protected <T> T runFlowAndGetPayload(String flowName) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent());
        return (T)response.getMessage().getPayload();
    }

    protected MuleMessage runFlowAndGetMessage(String flowName) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent());
        return response.getMessage();
    }

    protected <T> T runFlowAndGetInvocationProperty(String flowName, String invocationProperty) throws Exception {
        return (T)this.runFlowAndGetMessage(flowName).getInvocationProperty(invocationProperty);
    }

    protected MuleMessage runFlowAndGetMessage(String flowName, String beanId) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent(beanId));
        return response.getMessage();
    }

    protected <T> T runFlowAndGetPayload(String flowName, String beanId) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent(beanId));
        return (T)response.getMessage().getPayload();
    }

    protected void runFlowIgnoringPayload(String flowName) throws Exception {
        this.runFlowAndGetPayload(flowName);
    }

    protected <T> T runFlowAndWaitForResponseVM(String messageFlow, String vmQueueName, long timeoutMs) throws Exception {
        String vmEndpointUrl = "vm://" + vmQueueName;
        LocalMuleClient client = muleContext.getClient();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable waitForResponse = new Callable<T>((MuleClient)client, vmEndpointUrl){
            final /* synthetic */ MuleClient val$client;
            final /* synthetic */ String val$vmEndpointUrl;
            {
                this.val$client = muleClient;
                this.val$vmEndpointUrl = string;
            }

            @Override
            public T call() throws Exception {
                return this.val$client.request(this.val$vmEndpointUrl, Long.MAX_VALUE).getPayload();
            }
        };
        FutureTask futureResponse = new FutureTask(waitForResponse);
        executor.submit(futureResponse);
        this.runFlowAndGetPayload(messageFlow);
        return (T)futureResponse.get(timeoutMs, TimeUnit.MILLISECONDS);
    }

    protected Testable getGlobalElementTestable(String globalElementName) {
        Object lookupObject = muleContext.getRegistry().lookupObject(globalElementName);
        if (lookupObject == null) {
            throw new GlobalElementNotFoundException("No global element was found for " + globalElementName);
        }
        return (Testable)lookupObject;
    }

    public final void assertGetMetaDataKeysSuccess(String configName) {
        ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)muleContext.getRegistry().lookupObject(configName);
        Result metaDataKeysResults = connector.getMetaDataKeys();
        Assert.assertTrue((boolean)Result.Status.SUCCESS.equals((Object)metaDataKeysResults.getStatus()));
    }

    public final List<MetaDataKey> getMetaDataKeyList(String configName) {
        ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)muleContext.getRegistry().lookupObject(configName);
        Result metaDataKeysResults = connector.getMetaDataKeys();
        return (List)metaDataKeysResults.get();
    }

    public final void assertMetaDataKeysContainsKeys(String configName, List<HashMap<String, String>> expectedMetaDataKeyList) {
        boolean found = false;
        List<MetaDataKey> retrievedMetaDataKeyList = this.getMetaDataKeyList(configName);
        Iterator<HashMap<String, String>> expectedMetaDataKeys = expectedMetaDataKeyList.iterator();
        while (expectedMetaDataKeys.hasNext()) {
            Iterator<MetaDataKey> retrievedMetaDataKeys = retrievedMetaDataKeyList.iterator();
            HashMap<String, String> expectedMetaDataKey = expectedMetaDataKeys.next();
            while (retrievedMetaDataKeys.hasNext() && !found) {
                MetaDataKey metaDataKey = retrievedMetaDataKeys.next();
                String currentMetaDataKeyId = metaDataKey.getId();
                if (!currentMetaDataKeyId.equals(expectedMetaDataKey.get("id"))) continue;
                Assert.assertTrue((String)String.format("Retrieved MetaDataKey displayName for id %s does not match with value on provided MetaDataKey", currentMetaDataKeyId), (boolean)metaDataKey.getDisplayName().equals(expectedMetaDataKey.get("displayName").toString()));
                Assert.assertTrue((String)String.format("Retrieved MetaDataKey category for id %s does not match with value on provided MetaDataKey", currentMetaDataKeyId), (boolean)metaDataKey.getCategory().equals(expectedMetaDataKey.get("category").toString()));
                found = true;
            }
            Assert.assertTrue((String)"MetaDataKey id was not found on provided MetaDataKey list", (boolean)found);
        }
    }

    public final void assertIsMetaDataEnabled(String flowName) {
        MessageProcessor messageProcessor = (MessageProcessor)((Flow)muleContext.getRegistry().lookupFlowConstruct(flowName)).getMessageProcessors().get(0);
        Assert.assertThat((Object)messageProcessor, (Matcher)CoreMatchers.instanceOf(OperationMetaDataEnabled.class));
    }

    public final void assertNotMetaDataEnabled(String flowName) {
        MessageProcessor messageProcessor = (MessageProcessor)((Flow)muleContext.getRegistry().lookupFlowConstruct(flowName)).getMessageProcessors().get(0);
        Assert.assertThat((Object)messageProcessor, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(OperationMetaDataEnabled.class)));
    }

    public final Result<MetaData> getInputMetaData(String flowName) {
        return ((OperationMetaDataEnabled)((Flow)muleContext.getRegistry().lookupFlowConstruct(flowName)).getMessageProcessors().get(0)).getInputMetaData();
    }

    public final MetaDataModel getInputMetaDataPayload(String flowName) {
        return ((MetaData)this.getInputMetaData(flowName).get()).getPayload();
    }

    public final Result<MetaData> getOutputMetaData(String flowName) {
        return ((OperationMetaDataEnabled)((Flow)muleContext.getRegistry().lookupFlowConstruct(flowName)).getMessageProcessors().get(0)).getOutputMetaData(null);
    }

    public final MetaDataModel getOutputMetaDataPayload(String flowName) {
        return ((MetaData)this.getOutputMetaData(flowName).get()).getPayload();
    }

    public final void assertNullInputMetaDataSuccess(String flowName) {
        Result<MetaData> input = this.getInputMetaData(flowName);
        Assert.assertTrue((boolean)Result.Status.SUCCESS.equals((Object)input.getStatus()));
        Assert.assertTrue((input.get() == null ? 1 : 0) != 0);
    }

    public final void assertFirstLevelInputMetaDataSuccess(String flowName, DataType expectedDataType) {
        Result<MetaData> input = this.getInputMetaData(flowName);
        Assert.assertTrue((boolean)Result.Status.SUCCESS.equals((Object)input.getStatus()));
        Assert.assertTrue((boolean)((MetaData)input.get()).getPayload().getDataType().equals((Object)expectedDataType));
    }

    public final void assertNullOutputMetaDataSuccess(String flowName) {
        Result<MetaData> output = this.getOutputMetaData(flowName);
        Assert.assertTrue((boolean)Result.Status.SUCCESS.equals((Object)output.getStatus()));
        Assert.assertTrue((output.get() == null ? 1 : 0) != 0);
    }

    public final void assertFirstLevelOutputMetaDataSuccess(String flowName, DataType expectedDataType) {
        Result<MetaData> output = this.getOutputMetaData(flowName);
        Assert.assertTrue((boolean)output.getStatus().equals((Object)Result.Status.SUCCESS));
        Assert.assertTrue((boolean)((MetaData)output.get()).getPayload().getDataType().equals((Object)expectedDataType));
    }

    public final void assertPOJOOutputMetaDataSuccess(String flowName, String expectedImplementationType) {
        Result<MetaData> output = this.getOutputMetaData(flowName);
        Assert.assertTrue((boolean)output.getStatus().equals((Object)Result.Status.SUCCESS));
        Assert.assertTrue((boolean)((MetaData)output.get()).getPayload().getDataType().equals((Object)DataType.POJO));
        String actualImplementationType = ((MetaData)output.get()).getPayload().getImplementationClass();
        Assert.assertTrue((boolean)actualImplementationType.equals(expectedImplementationType));
    }

    public final void assertListFirstLevelOutputMetaDataSuccess(String flowName, String expectedImplementationType) {
        Result<MetaData> output = this.getOutputMetaData(flowName);
        DataType actualDataType = ((MetaData)output.get()).getPayload().getDataType();
        String actualImplementationType = ((MetaData)output.get()).getPayload().getImplementationClass();
        Assert.assertTrue((boolean)output.getStatus().equals((Object)Result.Status.SUCCESS));
        Assert.assertTrue((boolean)actualDataType.equals((Object)DataType.LIST));
        actualImplementationType = ((DefaultListMetaDataModel)((MetaData)output.get()).getPayload()).getElementModel().getImplementationClass();
        Assert.assertTrue((boolean)actualImplementationType.equals(expectedImplementationType));
    }

    static {
        testFlowsNames = new LinkedList<String>();
    }
}

