/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.tests;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectorTestCase
extends FunctionalTestCase {
    private static final Logger LOGGER = Logger.getLogger(ConnectorTestCase.class);
    protected static final String DEFAULT_SPRING_CONFIG_FILE = "AutomationSpringBeans.xml";
    protected static List<String> SPRING_CONFIG_FILES = new LinkedList<String>();
    private Map<String, Object> testData = new HashMap<String, Object>();
    private static ApplicationContext context;

    @BeforeClass
    public static void beforeClass() {
        SPRING_CONFIG_FILES.add(DEFAULT_SPRING_CONFIG_FILE);
        try {
            context = new ClassPathXmlApplicationContext(ConnectorTestCase.getConfigSpringFiles());
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Spring beans file was not found. Couldn't create the context for ConnectorTestParent.");
        }
    }

    protected static String[] getConfigSpringFiles() {
        return SPRING_CONFIG_FILES.toArray(new String[SPRING_CONFIG_FILES.size()]);
    }

    protected static void addConfigSpringFile(String fileLocation) {
        SPRING_CONFIG_FILES.add(fileLocation);
    }

    protected static void setConfigSpringFiles(List<String> configFilesLocation) {
        SPRING_CONFIG_FILES = configFilesLocation;
    }

    protected String getConfigResources() {
        return this.getConfigXmlFile();
    }

    protected String getConfigXmlFile() {
        return "automation-test-flows.xml";
    }

    private MuleEvent generateMuleEvent(String ... beanId) throws Exception {
        Boolean payloadContent;
        Object payload = null;
        HashMap dataValues = new HashMap();
        dataValues.putAll(this.testData);
        if (beanId.length != 0) {
            dataValues = (HashMap)context.getBean(beanId[0]);
        }
        if ((payloadContent = Boolean.valueOf(dataValues.containsKey("payloadContent"))).booleanValue()) {
            payload = dataValues.get("payloadContent");
        }
        MuleEvent event = ConnectorTestCase.getTestEvent(payload);
        for (String key : dataValues.keySet()) {
            event.setFlowVariable(key, dataValues.get(key));
        }
        if (payloadContent.booleanValue()) {
            event.removeFlowVariable("payloadContent");
        }
        return event;
    }

    protected Flow lookupFlowConstruct(String name) {
        return (Flow)muleContext.getRegistry().lookupFlowConstruct(name);
    }

    @Deprecated
    protected void loadTestRunMessage(String beanId) {
        Object bean = context.getBean(beanId);
        this.testData.clear();
        if (bean instanceof Map) {
            this.testData.putAll((Map)context.getBean(beanId));
        } else {
            this.testData.put(beanId, bean);
        }
    }

    @Deprecated
    public void loadTestRunMessage(Map<String, Object> data) {
        this.testData.clear();
        this.testData.putAll(data);
    }

    protected void initializeTestRunMessage(String beanId) {
        Object bean = context.getBean(beanId);
        this.testData.clear();
        if (bean instanceof Map) {
            this.testData.putAll((Map)context.getBean(beanId));
        } else {
            this.testData.put(beanId, bean);
        }
    }

    public void initializeTestRunMessage(String key, Object value) {
        this.testData.clear();
        this.testData.put(key, value);
    }

    public void initializeTestRunMessage(Map<String, Object> data) {
        this.testData.clear();
        this.testData.putAll(data);
    }

    public <T> T getBeanFromContext(String beanId) throws BeansException {
        return (T)context.getBean(beanId);
    }

    public void upsertBeanFromContextOnTestRunMessage(String beanId) {
        Object bean = this.getBeanFromContext(beanId);
        this.testData.put(beanId, bean);
    }

    public void upsertBeanFromContextOnTestRunMessage(String key, String beanId) {
        Object bean = this.getBeanFromContext(beanId);
        this.testData.put(key, bean);
    }

    public void upsertOnTestRunMessage(String key, Object value) {
        this.testData.put(key, value);
    }

    public void upsertOnTestRunMessage(Map<String, Object> data) {
        this.testData.putAll(data);
    }

    public <T> T getTestRunMessageValue(String key) {
        return (T)this.testData.get(key);
    }

    public void removeFromTestRunMessage(String key) {
        this.testData.remove(key);
    }

    public boolean keyContainedInTestRunMessage(Object key) {
        return this.testData.containsKey(key);
    }

    public Set<String> getTestRunMessageKeySet() {
        return this.testData.keySet();
    }

    protected <T> T runFlowAndGetPayload(String flowName) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent(new String[0]));
        return (T)response.getMessage().getPayload();
    }

    protected MuleMessage runFlowAndGetMessage(String flowName) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent(new String[0]));
        return response.getMessage();
    }

    protected <T> T runFlowAndGetInvocationProperty(String flowName, String invocationProperty) throws Exception {
        return (T)this.runFlowAndGetMessage(flowName).getInvocationProperty(invocationProperty);
    }

    protected MuleMessage runFlowAndGetMessage(String flowName, String beanId) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent(beanId));
        return response.getMessage();
    }

    protected <T> T runFlowAndGetPayload(String flowName, String beanId) throws Exception {
        MuleEvent response = this.lookupFlowConstruct(flowName).process(this.generateMuleEvent(beanId));
        return (T)response.getMessage().getPayload();
    }
}

