/**
 * (c) 2003-2013 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.tests;

import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.util.HashMap;
import java.util.Map;

/**
 * Connector Tests Framework Parent Class
 *
 * @author Mulesoft, Inc
 */
@SuppressWarnings("unchecked")
public abstract class TestParent extends FunctionalTestCase {

    private static final Logger LOGGER = Logger.getLogger(TestParent.class);
    private static final String DEFAULT_SPRING_CONFIG_FILE = "AutomationSpringBeans.xml";

    protected static final String[] SPRING_CONFIG_FILES = new String[] { DEFAULT_SPRING_CONFIG_FILE };
    protected static ApplicationContext context;

    private Map<String,Object> messageTestObject = new HashMap<String, Object>();

    @BeforeClass
    public static void beforeClass(){
        try {
            context = new ClassPathXmlApplicationContext(SPRING_CONFIG_FILES);
        } catch (Exception e) {
            LOGGER.warn("The default Spring beans config file was not found. Couldn't create the context for TestParent.");
        }
    }

    @Override
    protected String getConfigResources() {
        return getConfigXmlFile();
    }

    /**
     * Allows the user to override the default xml file
     * @return Mule xml config file
     */
    protected String getConfigXmlFile() {
        return "automation-test-flows.xml";
    }

    /**
     * Runs a flow using messageTestObject as payload. If something fails it throws the actual exception
     * and not the Mule MessagingException wrapper
     *
     * @param flowName name of the flow to run
     * @return message payload
     * @throws Exception
     */
    protected <T> T runFlowAndGetPayload(String flowName) throws Exception {
        MuleEvent response = null;

        try {
            response = lookupFlowConstruct(flowName).process(getTestEvent(messageTestObject));
        } catch (Exception e) {
            if (e instanceof MessagingException) {
                throw ((MessagingException) e).getCauseException();
            }
        }

        if (response != null) {
            return (T) response.getMessage().getPayload();
        } else {
            return null;
        }
    }

    /**
     * Adds a value to the message test object
     * @param key key
     * @param value value
     */
    protected void addToMessageTestObject(String key, Object value) {
        messageTestObject.put(key, value);
    }

    /**
     * Adds a complete map to the message test object
     * @param testObject map to be added to the Message test object
     */
    protected void addToMessageTestObject(Map testObject) {
        messageTestObject.putAll(testObject);
    }

    /**
     * Retrieves a value from the message test object using the given key
     *
     * @param key key
     * @return value from Message test object
     */
    protected <T> T getValueFromMessageTestObject(String key) {
        return (T) messageTestObject.get(key);
    }

    /**
     * Retrieve a flow by name from the registry
     *
     * @param name Name of the flow to retrieve
     */
    protected Flow lookupFlowConstruct(String name)
    {
        return (Flow) muleContext.getRegistry().lookupFlowConstruct(name);
    }
}
