/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.salesforcepubsub;

import com.mulesoft.connector.salesforce.pubsub.internal.protobuf.PublishResult;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.mule.extension.async.apikit.api.PublishResponse;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.operations.PublishParameters;
import org.mule.extension.async.apikit.internal.protocols.PublishHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.client.params.Parameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforcePubSubPublishHandler
implements PublishHandler<PublishResult, Void> {
    protected static final Logger logger = LoggerFactory.getLogger(SalesforcePubSubPublishHandler.class);
    private final String configRef;
    private final ExpressionManager expressionManager;
    private final CompiledExpression transFormToEventsExpression;

    public SalesforcePubSubPublishHandler(String configRef, ExpressionManager expressionManager) {
        this.configRef = configRef;
        this.expressionManager = expressionManager;
        this.transFormToEventsExpression = this.getCompiledExpression();
    }

    @Override
    public String getPublishOperationName() {
        return "publishEvent";
    }

    @Override
    public Consumer<OperationParameterizer> configurePublishOperationFor(PublishParameters parameters, TypedValue<InputStream> content, List<Binding> asyncBindings) {
        return operationParameterizer -> {
            BindingContext context = BindingContext.builder().addBinding("payload", content).build();
            try (ExpressionManagerSession session = this.expressionManager.openSession(context);){
                TypedValue typedValue = session.evaluate(this.transFormToEventsExpression);
                ((OperationParameterizer)((OperationParameterizer)operationParameterizer.withConfigRef(this.configRef)).withParameter("events", typedValue.getValue())).withParameter("topic", (Object)parameters.getChannelName());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new AsyncApiModuleException(e);
            }
            asyncBindings.forEach(asyncBinding -> asyncBinding.applyBindings((Parameterizer)operationParameterizer));
        };
    }

    @Override
    public Result<PublishResponse, Void> handleResult(Result<PublishResult, Void> result) {
        HashMap<String, Object> outputMetadata = new HashMap<String, Object>();
        outputMetadata.put("STATUS", "SUCCESS");
        PublishResponse resultingOutput = new PublishResponse(outputMetadata);
        return Result.builder().output((Object)resultingOutput).build();
    }

    private CompiledExpression getCompiledExpression() {
        String transformScript = "%dw 2.0\noutput application/java\n---\npayload";
        return this.expressionManager.compile(transformScript, BindingContextUtils.getTargetBindingContext((Message)Message.of((Object)"")));
    }
}

