/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.salesforcepubsub;

import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.salesforcepubsub.SalesforcePubSubConfig;
import org.mule.extension.async.apikit.internal.protocols.salesforcepubsub.SalesforcePubSubMessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.salesforcepubsub.SalesforcePubSubPublishHandler;
import org.mule.runtime.api.util.Pair;

public class SalesforcePubSubProtocolHandler
extends ProtocolHandler<SalesforcePubSubMessageListenerHandler, SalesforcePubSubPublishHandler> {
    @Override
    public String getExtensionName() {
        return "Salesforce PubSub";
    }

    @Override
    public void buildMessageListenerHandlersFor(AsyncConfig config, String server, String channelName, boolean disableValidation, String defaultEncoding) {
        SalesforcePubSubConfig salesforcePubSubConfig = config.getSalesforcePubSubConfigs().stream().filter(c -> c.getServerKey().equals(server)).findFirst().orElseThrow(() -> new AsyncApiModuleException("No server found with key '{}'", server));
        Pair handlerKey = new Pair((Object)server, (Object)channelName);
        SalesforcePubSubMessageListenerHandler messageListenerHandler = this.messageListenerHandlers.computeIfAbsent(handlerKey, key -> new SalesforcePubSubMessageListenerHandler(config.getApi(), config.getSourceCallbackRegistry(), config, config.getAsyncApiAmfConfiguration().elementClient(), server, disableValidation, channelName, salesforcePubSubConfig.getConfigRef(), config.getBindingsHandler().getSourceListenerAsyncBindings(channelName), defaultEncoding));
        this.sourceHandlers.putIfAbsent(handlerKey, config.getExtensionsClient().createSource(this.getExtensionName(), messageListenerHandler.getSourceListenerName(), messageListenerHandler::consumeSourceListenerResult, messageListenerHandler::configureSourceListener));
    }

    @Override
    public void buildPublishHandlersFor(AsyncConfig config, String server, String channelName) {
        SalesforcePubSubConfig salesforcePubSubConfig = (SalesforcePubSubConfig)this.getServerConfig(config.getSalesforcePubSubConfigs(), server);
        this.publishHandlers.putIfAbsent(new Pair((Object)server, (Object)channelName), new SalesforcePubSubPublishHandler(salesforcePubSubConfig.getConfigRef(), config.getExpressionManager()));
    }
}

