/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.amq;

import java.util.List;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQConfig;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQMessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQPublishHandler;
import org.mule.runtime.api.util.Pair;

public class AnypointMQProtocolHandler
extends ProtocolHandler<AnypointMQMessageListenerHandler, AnypointMQPublishHandler> {
    @Override
    public String getExtensionName() {
        return "Anypoint MQ";
    }

    @Override
    public void buildMessageListenerHandlersFor(AsyncConfig config, String server, String channelName, boolean disableValidation, String defaultEncoding) {
        List<AnypointMQConfig> anyPointMQConfigs = config.getAnyPointMQConfigs();
        AnypointMQConfig anypointMQConfig = (AnypointMQConfig)this.getServerConfig(anyPointMQConfigs, server);
        Pair handlerKey = new Pair((Object)server, (Object)channelName);
        this.applyChannelBindings(config, channelName, ProtocolHandler.Protocol.ANYPOINTMQ);
        AnypointMQMessageListenerHandler messageListenerHandler = this.messageListenerHandlers.computeIfAbsent(handlerKey, key -> new AnypointMQMessageListenerHandler(config.getApi(), config.getSourceCallbackRegistry(), config, config.getAsyncApiAmfConfiguration().elementClient(), disableValidation, server, channelName, anypointMQConfig.getConfigRef(), config.getBindingsHandler().getSourceListenerAsyncBindings(channelName), defaultEncoding));
        this.sourceHandlers.putIfAbsent(handlerKey, config.getExtensionsClient().createSource(this.getExtensionName(), messageListenerHandler.getSourceListenerName(), messageListenerHandler::consumeSourceListenerResult, messageListenerHandler::configureSourceListener));
    }

    @Override
    public void buildPublishHandlersFor(AsyncConfig config, String server, String channelName) {
        AnypointMQConfig anypointMQConfig = (AnypointMQConfig)this.getServerConfig(config.getAnyPointMQConfigs(), server);
        this.publishHandlers.putIfAbsent(new Pair((Object)server, (Object)channelName), new AnypointMQPublishHandler(anypointMQConfig.getConfigRef()));
    }
}

