/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.io.InputStream;
import java.util.List;
import org.mule.extension.async.apikit.api.attributes.AsyncMessageAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.ValidationResult;
import org.mule.extension.async.apikit.internal.exception.AsyncApiValidationException;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.extension.async.apikit.internal.sources.RoutingKey;
import org.mule.extension.async.apikit.internal.validation.AsyncOperation;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageListenerHandler<T, A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListenerHandler.class);
    public static final String RESULT_HANDLER_CTX_KEY = "SourceResultHandlerKey";
    protected final AsyncApi api;
    protected final String channelName;
    protected final String serverName;
    protected final boolean disableValidation;
    protected final SourceCallbackRegistry registry;
    protected final AMFElementClient amfElementClient;
    protected final AsyncConfig asyncConfig;
    protected final List<Binding> asyncBindings;
    protected ComponentLocation componentLocation;
    protected String defaultEncoding;

    public MessageListenerHandler(AsyncApi api, SourceCallbackRegistry registry, AsyncConfig config, AMFElementClient amfElementClient, boolean disableValidation, String serverName, String channelName, List<Binding> asyncBindings, String defaultEncoding) {
        this.api = api;
        this.channelName = channelName;
        this.registry = registry;
        this.serverName = serverName;
        this.asyncConfig = config;
        this.disableValidation = disableValidation;
        this.amfElementClient = amfElementClient;
        this.asyncBindings = asyncBindings;
        this.defaultEncoding = defaultEncoding;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    protected abstract String getRuntimeChannelName(Result<T, A> var1);

    public abstract String getSourceListenerName();

    public abstract void configureSourceListener(SourceParameterizer var1);

    protected abstract AsyncMessageAttributes buildResultAttributes(Result<T, A> var1, String var2);

    protected abstract InputStream buildResultOutput(Result<T, A> var1);

    public void consumeSourceListenerResult(SourceResultHandler<T, A> sourceResultHandler) {
        if (sourceResultHandler.getResult() == null) {
            sourceResultHandler.completeWithSuccess(p -> {});
            return;
        }
        String runtimeChannel = this.getRuntimeChannelName(sourceResultHandler.getResult());
        String specChannel = this.asyncConfig.getChannelBasedRegistry().getSpecChannelByRuntimeChannel(runtimeChannel);
        SourceCallback<InputStream, AsyncMessageAttributes> sourceCallback = this.registry.getSourceCallback(new RoutingKey(specChannel));
        if (sourceCallback == null) {
            LOGGER.warn("No source callback found for channel '{}'. The channel does not match any from the ones defined in the spec.", (Object)specChannel);
            sourceResultHandler.completeWithSuccess(p -> {});
            return;
        }
        try {
            InputStream input = this.buildResultOutput(sourceResultHandler.getResult());
            if (!this.disableValidation) {
                String mimeType = AsyncApiUtils.getMimeType(AsyncApiUtils.getResolvedMediaType(this.api, sourceResultHandler.getResult().getMediaType(), this.defaultEncoding));
                List<AMFShapePayloadValidator> validators = this.asyncConfig.getSchemaRegistry().getValidators(this.api, specChannel, AsyncOperation.PUBLISH, mimeType, this.amfElementClient);
                List<ValidationResult> results = AsyncApiUtils.validate(validators, this.channelName, mimeType, input);
                if (!results.isEmpty()) {
                    AsyncApiValidationException e = AsyncApiValidationException.fromValidationResults(results);
                    LOGGER.error("Validation failed for channel {} at {}", new Object[]{runtimeChannel, this.componentLocation.getLocation(), e});
                    sourceResultHandler.completeWithSuccess(p -> {});
                    return;
                }
            }
            MediaType mediaType = AsyncApiUtils.getResolvedMediaType(this.api, sourceResultHandler.getResult().getMediaType(), this.defaultEncoding);
            SourceCallbackContext ctx = sourceCallback.createContext();
            ctx.addVariable(RESULT_HANDLER_CTX_KEY, sourceResultHandler);
            sourceCallback.handle(Result.builder().output((Object)input).mediaType(mediaType).attributes((Object)this.buildResultAttributes(sourceResultHandler.getResult(), specChannel)).build(), ctx);
        }
        catch (Exception e) {
            LOGGER.error("Error in listener handler while processing the message at {}, channel={}", new Object[]{this.componentLocation.getLocation(), runtimeChannel, e});
            sourceResultHandler.completeWithError((Throwable)e, p -> {});
        }
    }
}

