/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.metadata;

import amf.apicontract.client.platform.model.domain.Operation;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.UnionShape;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.metadata.MetadataFactory;
import org.mule.extension.async.apikit.internal.operations.PublishParameters;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;

public class PublishInputTypeResolver
implements InputTypeResolver<PublishParameters> {
    public String getCategoryName() {
        return "PublishOperationResolver";
    }

    public String getResolverName() {
        return "PublishInputTypeResolver";
    }

    public MetadataType getInputMetadata(MetadataContext metadataContext, PublishParameters key) throws MetadataResolvingException {
        AsyncConfig config = (AsyncConfig)metadataContext.getConfig().get();
        MetadataFactory.exitIfNotReady(config);
        String specChannel = config.getChannelBasedRegistry().getSpecChannelByRuntimeChannel(key.getChannelName());
        Optional<Operation> operation = AsyncApiUtils.getProducerOperation(config.getApi(), specChannel);
        if (!operation.isPresent()) {
            return MetadataFactory.getDefaultMetadataType(metadataContext);
        }
        List shapes = operation.get().responses().stream().flatMap(r -> r.payloads().stream()).map(p -> p.schema()).collect(Collectors.toList());
        List<String> schemaTypes = operation.get().responses().stream().flatMap(r -> r.payloads().stream()).map(p -> p.mediaType().value()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Shape shape = shapes.size() > 1 ? new UnionShape().withAnyOf(shapes) : (Shape)shapes.get(0);
        return new MetadataFactory(metadataContext).getMetadataType(shape, schemaTypes);
    }
}

