/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.APIConfiguration;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.common.transform.PipelineId;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.AMFResult;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.ResourceLoader;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.internal.remote.Spec;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extension.async.apikit.internal.execution.ChannelBasedRegistry;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.operations.PublishOperation;
import org.mule.extension.async.apikit.internal.parser.APISyncResourceLoader;
import org.mule.extension.async.apikit.internal.parser.ApiResource;
import org.mule.extension.async.apikit.internal.parser.EventedZipFileDependencyFetcher;
import org.mule.extension.async.apikit.internal.parser.EventedZipFileResourceLoader;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandlerFactory;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQConfig;
import org.mule.extension.async.apikit.internal.protocols.bindings.BindingsHandler;
import org.mule.extension.async.apikit.internal.protocols.kafka.KafkaConfig;
import org.mule.extension.async.apikit.internal.protocols.salesforcepubsub.SalesforcePubSubConfig;
import org.mule.extension.async.apikit.internal.protocols.solace.SolaceConfig;
import org.mule.extension.async.apikit.internal.sources.AsyncMessageListenerSource;
import org.mule.extension.async.apikit.internal.validation.SchemaRegistry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.source.SourceHandler;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactConstants;
import org.mule.sdk.api.annotation.param.RuntimeVersion;
import org.mulesoft.apb.client.platform.APBClient;
import org.mulesoft.apb.client.platform.APBClientBuilder;
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={PublishOperation.class})
@Sources(value={AsyncMessageListenerSource.class})
public class AsyncConfig
implements Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(AsyncConfig.class);
    @Parameter
    @Summary(value="API definition")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Path
    private String apiDefinition;
    @Parameter
    @Summary(value="Disable payload content validation")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean disableContentValidation;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of Kafka configurations")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<KafkaConfig> kafkaConfigs;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of AMQ configurations")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<AnypointMQConfig> anypointMQConfigs;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of Solace configurations")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<SolaceConfig> solaceConfigs;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of SalesforcePubSub configurations")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<SalesforcePubSubConfig> salesforcePubSubConfigs;
    @Inject
    private ExtensionsClient extensionsClient;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    ExpressionManager expressionManager;
    @Inject
    ExpressionLanguageMetadataService expressionLanguageMetadataService;
    @RuntimeVersion
    private MuleVersion muleVersion;
    private Scheduler scheduler;
    private AsyncApi api;
    private SourceCallbackRegistry sourceCallbackRegistry;
    private AMFConfiguration asyncApiAmfConfiguration;
    private ChannelBasedRegistry channelBasedRegistry;
    private SchemaRegistry schemaRegistry;
    private Map<String, ProtocolHandler<?, ?>> protocolHandlers;
    private BindingsHandler bindingsHandler;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void initialise() throws InitialisationException {
        ArtifactConstants.getApiClassifiers().add("evented-api");
        this.api = this.parseApi(this.apiDefinition);
        this.scheduler = this.getScheduler();
        this.sourceCallbackRegistry = new SourceCallbackRegistry();
        this.channelBasedRegistry = new ChannelBasedRegistry();
        this.schemaRegistry = new SchemaRegistry(this);
        this.buildProtocolHandlers();
        this.bindingsHandler = new BindingsHandler(this.api);
        this.initialized.set(true);
    }

    public void dispose() {
        this.scheduler.shutdownNow();
        for (ProtocolHandler<?, ?> protocolHandler : this.protocolHandlers.values()) {
            Map<Pair<String, String>, SourceHandler> sourceHandlers = protocolHandler.getSourceHandlers();
            sourceHandlers.values().forEach(SourceHandler::dispose);
        }
        ArtifactConstants.getApiClassifiers().remove("evented-api");
    }

    public void start() throws MuleException {
        this.channelBasedRegistry.registerChannelPatterns(this);
    }

    public void stop() throws MuleException {
    }

    private Scheduler getScheduler() {
        return this.schedulerService.cpuIntensiveScheduler();
    }

    public String getApiDefinition() {
        return this.apiDefinition;
    }

    public ExtensionsClient getExtensionsClient() {
        return this.extensionsClient;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }

    public MuleVersion getMuleVersion() {
        return this.muleVersion;
    }

    public List<KafkaConfig> getKafkaConfigs() {
        return this.kafkaConfigs;
    }

    public List<AnypointMQConfig> getAnyPointMQConfigs() {
        return this.anypointMQConfigs;
    }

    public List<SolaceConfig> getSolaceConfigs() {
        return this.solaceConfigs;
    }

    public List<SalesforcePubSubConfig> getSalesforcePubSubConfigs() {
        return this.salesforcePubSubConfigs;
    }

    public SourceCallbackRegistry getSourceCallbackRegistry() {
        return this.sourceCallbackRegistry;
    }

    public BindingsHandler getBindingsHandler() {
        return this.bindingsHandler;
    }

    public AsyncApi getApi() {
        return this.api;
    }

    public ChannelBasedRegistry getChannelBasedRegistry() {
        return this.channelBasedRegistry;
    }

    public SchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    public AsyncApi parseApi(String api) throws InitialisationException {
        ExecutionEnvironment executionEnv = new ExecutionEnvironment((ScheduledExecutorService)this.scheduler);
        Object resourceLoader = null;
        AMFParseResult parseResult = null;
        if (api.startsWith("resource::")) {
            ApiResource apiResource = new ApiResource(api);
            String apiPath = apiResource.getApiPath();
            resourceLoader = new EventedZipFileResourceLoader();
            parseResult = this.parseAPIProject((ResourceLoader)resourceLoader, apiPath);
        } else if (api.endsWith(".zip")) {
            resourceLoader = new EventedZipFileResourceLoader();
            String path = AsyncConfig.class.getClassLoader().getResource(api).getPath();
            parseResult = this.parseAPIProject((ResourceLoader)resourceLoader, path);
        } else {
            resourceLoader = new APISyncResourceLoader(api);
            parseResult = this.parseApiSpec(executionEnv, (ResourceLoader)resourceLoader, api);
        }
        if (!parseResult.conforms()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"API does not conform with AsyncAPI spec"), (Initialisable)this);
        }
        Spec spec = parseResult.sourceSpec();
        this.asyncApiAmfConfiguration = APIConfiguration.fromSpec((Spec)spec).withResourceLoader((ResourceLoader)resourceLoader).withExecutionEnvironment((BaseExecutionEnvironment)executionEnv);
        BaseUnit model = parseResult.baseUnit();
        AMFResult transformResult = this.asyncApiAmfConfiguration.baseUnitClient().transform(model, PipelineId.Editing());
        return (AsyncApi)((Document)transformResult.baseUnit()).encodes();
    }

    private AMFParseResult parseApiSpec(ExecutionEnvironment executionEnv, ResourceLoader resourceLoader, String api) throws InitialisationException {
        try {
            AMFConfiguration amfConfiguration = APIConfiguration.API().withResourceLoader(resourceLoader).withExecutionEnvironment((BaseExecutionEnvironment)executionEnv);
            AMFBaseUnitClient amfBaseUnitClient = amfConfiguration.baseUnitClient();
            CompletableFuture parseResult = amfBaseUnitClient.parse(api);
            return (AMFParseResult)parseResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Failed to parse API project"), (Throwable)e, (Initialisable)this);
        }
    }

    private AMFParseResult parseAPIProject(ResourceLoader resourceLoader, String apiPath) throws InitialisationException {
        String extractedSpec = null;
        try {
            extractedSpec = ApiResource.extractZipFile(apiPath);
            EventedZipFileDependencyFetcher fetcher = new EventedZipFileDependencyFetcher(extractedSpec);
            APBClientBuilder apbClientBuilder = new APBClientBuilder((DependencyFetcher)fetcher).withResourceLoaders(Collections.singletonList(resourceLoader));
            APBClient client = (APBClient)apbClientBuilder.build(extractedSpec).get();
            boolean conforms = ((AMFValidationReport)client.report().get()).conforms();
            CompletableFuture parseResult = client.compile();
            AMFParseResult aMFParseResult = (AMFParseResult)parseResult.get();
            return aMFParseResult;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Failed to parse API project "), (Throwable)e, (Initialisable)this);
        }
        finally {
            try {
                ApiResource.deleteDirectory(extractedSpec);
            }
            catch (IOException e) {
                logger.error(I18nMessageFactory.createStaticMessage((String)"Failed to delete extracted api directory {}").getMessage(), (Object)e.getMessage());
            }
        }
    }

    public AMFConfiguration getAsyncApiAmfConfiguration() {
        return this.asyncApiAmfConfiguration;
    }

    public ProtocolHandler<?, ?> getHandlerByServer(String server) {
        return this.protocolHandlers.get(server);
    }

    private void buildProtocolHandlers() {
        ProtocolHandler<?, ?> protocolHandler;
        this.protocolHandlers = new HashMap();
        ProtocolHandlerFactory protocolHandlerFactory = new ProtocolHandlerFactory();
        if (!this.kafkaConfigs.isEmpty()) {
            protocolHandler = protocolHandlerFactory.buildProtocolHandler(ProtocolHandler.Protocol.KAFKA);
            this.protocolHandlers.putAll((Map)this.kafkaConfigs.stream().collect(Collectors.toConcurrentMap(KafkaConfig::getServerKey, kafkaConfig -> protocolHandler)));
        }
        if (!this.anypointMQConfigs.isEmpty()) {
            protocolHandler = protocolHandlerFactory.buildProtocolHandler(ProtocolHandler.Protocol.ANYPOINTMQ);
            this.protocolHandlers.putAll((Map)this.anypointMQConfigs.stream().collect(Collectors.toConcurrentMap(AnypointMQConfig::getServerKey, amqConfig -> protocolHandler)));
        }
        if (!this.solaceConfigs.isEmpty()) {
            protocolHandler = protocolHandlerFactory.buildProtocolHandler(ProtocolHandler.Protocol.SOLACE);
            this.protocolHandlers.putAll((Map)this.solaceConfigs.stream().collect(Collectors.toConcurrentMap(SolaceConfig::getServerKey, solaceConfig -> protocolHandler)));
        }
        if (!this.salesforcePubSubConfigs.isEmpty()) {
            protocolHandler = protocolHandlerFactory.buildProtocolHandler(ProtocolHandler.Protocol.SALESFORCEPUBSUB);
            this.protocolHandlers.putAll((Map)this.salesforcePubSubConfigs.stream().collect(Collectors.toConcurrentMap(SalesforcePubSubConfig::getServerKey, salesforcePubSubConfig -> protocolHandler)));
        }
    }

    public AtomicBoolean isInitialized() {
        return this.initialized;
    }
}

