/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.solace;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import com.solace.connector.mulesoft.api.param.SolaceMessageProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.mule.extension.async.apikit.api.attributes.AsyncMessageAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.exception.AsyncApiRoutingException;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.protocols.MessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.extension.async.apikit.internal.protocols.solace.SolaceMessageAttributesBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.client.params.Parameterizer;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolaceMessageListenerHandler
extends MessageListenerHandler<Object, SolaceMessageProperties> {
    private static final Logger log = LoggerFactory.getLogger(SolaceMessageListenerHandler.class);
    protected String configRef;

    public SolaceMessageListenerHandler(AsyncApi api, SourceCallbackRegistry registry, AsyncConfig config, AMFElementClient amfElementClient, String serverName, boolean disableValidation, String channelName, String configRef, List<Binding> asyncBindings, String defaultEncoding) {
        super(api, registry, config, amfElementClient, disableValidation, serverName, channelName, asyncBindings, defaultEncoding);
        this.configRef = configRef;
    }

    @Override
    protected String getRuntimeChannelName(Result<Object, SolaceMessageProperties> result) {
        return this.channelName;
    }

    @Override
    public String getSourceListenerName() {
        return "queue-listener";
    }

    @Override
    public void configureSourceListener(SourceParameterizer sourceParameterizer) {
        ((SourceParameterizer)sourceParameterizer.withConfigRef(this.configRef)).withParameter("address", (Object)this.channelName);
        for (Binding asyncBinding : this.asyncBindings) {
            asyncBinding.applyBindings((Parameterizer)sourceParameterizer);
        }
    }

    @Override
    protected AsyncMessageAttributes buildResultAttributes(Result<Object, SolaceMessageProperties> result, String specChannel) {
        SolaceMessageProperties attributes = (SolaceMessageProperties)result.getAttributes().orElseThrow(() -> new AsyncApiRoutingException("Unable to get attributes from Solace message"));
        return ((SolaceMessageAttributesBuilder)((SolaceMessageAttributesBuilder)((SolaceMessageAttributesBuilder)SolaceMessageAttributesBuilder.builder().channelName(attributes.getDestination())).serverName(this.serverName)).protocol(ProtocolHandler.Protocol.SOLACE.name())).discardIndication(attributes.isDiscardIndication()).isElidingEligible(attributes.isElidingEligible()).isRedelivered(attributes.isRedelivered()).priority(attributes.getPriority()).isDMQEligible(attributes.isDMQEligible()).receiveTimestamp(attributes.getReceiveTimestamp()).timeToLive(attributes.getTimeToLive()).contentType(attributes.getContentType()).deliveryMode(attributes.getDeliveryMode()).endpointType(attributes.getEndpointType()).messageReferenceId(attributes.getMessageReferenceId()).isReply(attributes.isReply()).build();
    }

    @Override
    protected InputStream buildResultOutput(Result<Object, SolaceMessageProperties> result) {
        MediaType mediaType = AsyncApiUtils.getResolvedMediaType(this.api, result.getMediaType(), this.defaultEncoding);
        String charSet = AsyncApiUtils.getCharSet(Optional.of(mediaType), this.defaultEncoding);
        byte[] bytes = new byte[]{};
        try {
            if (result.getOutput() instanceof InputStream) {
                return (InputStream)result.getOutput();
            }
            if (result.getOutput() instanceof String) {
                bytes = ((String)result.getOutput()).getBytes(charSet);
            }
        }
        catch (Exception e) {
            log.error("Failure while creating result output for {}, correlation id -> {}", (Object)ProtocolHandler.Protocol.SOLACE.name(), (Object)result.getAttributes().orElse(new SolaceMessageProperties()).getCorrelationId());
            throw new AsyncApiModuleException("Failure while creating result output", e);
        }
        return new ByteArrayInputStream(bytes);
    }
}

