/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.kafka;

import com.mulesoft.connectors.kafka.api.operation.KafkaMessageMetadata;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.extension.async.apikit.api.PublishResponse;
import org.mule.extension.async.apikit.internal.operations.PublishParameters;
import org.mule.extension.async.apikit.internal.protocols.PublishHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.extension.async.apikit.internal.validation.AsyncOperation;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.client.params.Parameterizer;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class KafkaPublishHandler
implements PublishHandler<KafkaMessageMetadata, Void> {
    private final String producerConfigRef;

    public KafkaPublishHandler(String producerConfigRef) {
        this.producerConfigRef = producerConfigRef;
    }

    @Override
    public String getPublishOperationName() {
        return AsyncOperation.PUBLISH.label();
    }

    @Override
    public Consumer<OperationParameterizer> configurePublishOperationFor(PublishParameters parameters, TypedValue<InputStream> content, List<Binding> asyncBindings) {
        return operationParameterizer -> {
            ((OperationParameterizer)((OperationParameterizer)operationParameterizer.withConfigRef(this.producerConfigRef)).withParameter("message", content.getValue())).withParameter("topic", (Object)parameters.getChannelName());
            asyncBindings.forEach(asyncBinding -> asyncBinding.applyBindings((Parameterizer)operationParameterizer));
        };
    }

    @Override
    public Result<PublishResponse, Void> handleResult(Result<KafkaMessageMetadata, Void> result) {
        KafkaMessageMetadata output = (KafkaMessageMetadata)result.getOutput();
        MultiMap outputMetadata = new MultiMap();
        outputMetadata.put("topic", output.getTopic());
        outputMetadata.put("partition", output.getPartition());
        outputMetadata.put("offset", output.getOffset());
        outputMetadata.put("timestamp", output.getTimestamp());
        outputMetadata.put("serializedKeySize", output.getSerializedKeySize());
        outputMetadata.put("serializedValueSize", output.getSerializedValueSize());
        PublishResponse resultingOutput = new PublishResponse((Map<String, Object>)outputMetadata);
        return Result.builder().output((Object)resultingOutput).build();
    }
}

