/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols.bindings;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Message;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.AsyncChannelBinding;
import org.mule.extension.async.apikit.internal.protocols.bindings.AsyncMessageBinding;
import org.mule.extension.async.apikit.internal.protocols.bindings.AsyncOperationBinding;
import org.mule.extension.async.apikit.internal.protocols.bindings.AsyncServerBinding;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.extension.async.apikit.internal.protocols.bindings.BindingKey;
import org.mule.extension.async.apikit.internal.validation.AsyncOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindingsHandler.class);
    private final Map<BindingKey, AsyncServerBinding> serverBindings = new ConcurrentHashMap<BindingKey, AsyncServerBinding>();
    private final Map<BindingKey, AsyncChannelBinding> channelBindings = new ConcurrentHashMap<BindingKey, AsyncChannelBinding>();
    private final Map<String, AsyncMessageBinding> publishMessageBindings = new ConcurrentHashMap<String, AsyncMessageBinding>();
    private final Map<String, AsyncMessageBinding> subscribeMessageBindings = new ConcurrentHashMap<String, AsyncMessageBinding>();
    private final Map<BindingKey, AsyncOperationBinding> publishOperationBindings = new ConcurrentHashMap<BindingKey, AsyncOperationBinding>();
    private final Map<BindingKey, AsyncOperationBinding> subscribeOperationBindings = new ConcurrentHashMap<BindingKey, AsyncOperationBinding>();

    public BindingsHandler(AsyncApi api) {
        api.endPoints().forEach(this::registerChannelBindings);
        api.endPoints().forEach(ep -> {
            this.registerMessageBindings((EndPoint)ep, AsyncOperation.PUBLISH, this.getSubscribeMessageBindings());
            this.registerMessageBindings((EndPoint)ep, AsyncOperation.SUBSCRIBE, this.getPublishMessageBindings());
        });
        api.servers().forEach(this::registerServerBindings);
        api.endPoints().forEach(ep -> {
            this.registerOperationBindings((EndPoint)ep, AsyncOperation.PUBLISH, this.subscribeOperationBindings);
            this.registerOperationBindings((EndPoint)ep, AsyncOperation.SUBSCRIBE, this.publishOperationBindings);
        });
    }

    public Map<String, AsyncChannelBinding> getChannelBindings() {
        HashMap<String, AsyncChannelBinding> result = new HashMap<String, AsyncChannelBinding>();
        this.channelBindings.keySet().forEach(k -> result.putIfAbsent(k.getBindingTypeKey(), this.channelBindings.get(k)));
        return result;
    }

    public Map<String, AsyncMessageBinding> getSubscribeMessageBindings() {
        return this.subscribeMessageBindings;
    }

    public Map<String, AsyncMessageBinding> getPublishMessageBindings() {
        return this.publishMessageBindings;
    }

    public Optional<AsyncServerBinding> getServerBinding(String server, ProtocolHandler.Protocol protocol) {
        return Optional.ofNullable(this.serverBindings.get(new BindingKey(server, ProtocolHandler.serverBindingByProtocol(protocol).getName())));
    }

    public Optional<AsyncChannelBinding> getChannelAsyncBinding(String channel, ProtocolHandler.Protocol protocol) {
        return Optional.ofNullable(this.channelBindings.get(new BindingKey(channel, ProtocolHandler.channelBindingByProtocol(protocol).getName())));
    }

    public Optional<AsyncChannelBinding> getChannelBinding(String channel) {
        ArrayList<BindingKey> keys = new ArrayList<BindingKey>(this.channelBindings.keySet());
        Optional<BindingKey> first = keys.stream().filter(k -> k.getBindingTypeKey().equals(channel)).findFirst();
        return first.map(this.channelBindings::get);
    }

    public List<Binding> getPublishAsyncBindings(String channel) {
        AsyncOperationBinding operationBinding;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        this.getChannelBinding(channel).ifPresent(bindings::add);
        AsyncMessageBinding messageBinding = this.publishMessageBindings.get(channel);
        if (messageBinding != null) {
            bindings.add(messageBinding);
        }
        if ((operationBinding = this.publishOperationBindings.get(new BindingKey(channel, ProtocolHandler.operatorBindingByProtocol(ProtocolHandler.Protocol.SOLACE).getName()))) != null) {
            bindings.add(operationBinding);
        }
        return bindings;
    }

    public List<Binding> getSourceListenerAsyncBindings(String channel) {
        AsyncOperationBinding operationBinding;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        this.getChannelBinding(channel).ifPresent(bindings::add);
        AsyncMessageBinding messageBinding = this.subscribeMessageBindings.get(channel);
        if (messageBinding != null) {
            bindings.add(messageBinding);
        }
        if ((operationBinding = this.subscribeOperationBindings.get(new BindingKey(channel, ProtocolHandler.operatorBindingByProtocol(ProtocolHandler.Protocol.SOLACE).getName()))) != null) {
            bindings.add(operationBinding);
        }
        return bindings;
    }

    public Optional<AsyncOperationBinding> getPublishAsyncOperationBinding(String channel, ProtocolHandler.Protocol protocol) {
        return Optional.ofNullable(this.publishOperationBindings.get(new BindingKey(channel, ProtocolHandler.operatorBindingByProtocol(protocol).getName())));
    }

    public Optional<AsyncOperationBinding> getSubscribeAsyncOperationBinding(String channel, ProtocolHandler.Protocol protocol) {
        return Optional.ofNullable(this.subscribeOperationBindings.get(new BindingKey(channel, ProtocolHandler.operatorBindingByProtocol(protocol).getName())));
    }

    public void registerChannelBindings(EndPoint endPoint) {
        if (endPoint.bindings() != null) {
            endPoint.bindings().bindings().forEach(b -> this.channelBindings.putIfAbsent(new BindingKey(endPoint.path().value(), ProtocolHandler.stripClassVersioning(b.getClass().getName())), AsyncChannelBinding.fromChannelBinding(b)));
        }
    }

    public void registerServerBindings(Server server) {
        if (server.bindings() != null) {
            server.bindings().bindings().stream().forEach(b -> this.serverBindings.putIfAbsent(new BindingKey(server.name().value(), b.getClass().getName()), AsyncServerBinding.fromServerBinding(b)));
        }
    }

    private void registerOperationBindings(EndPoint endPoint, AsyncOperation operation, Map<BindingKey, AsyncOperationBinding> bindingsMap) {
        endPoint.operations().stream().filter(op -> op.method().is((Object)operation.label())).map(Operation::bindings).filter(Objects::nonNull).flatMap(b -> b.bindings().stream()).forEach(ob -> bindingsMap.putIfAbsent(new BindingKey(endPoint.path().value(), ProtocolHandler.stripClassVersioning(ob.getClass().getName())), AsyncOperationBinding.fromOperationBinding(ob, operation)));
    }

    public void registerMessageBindings(EndPoint endPoint, AsyncOperation operation, Map<String, AsyncMessageBinding> bindingsMap) {
        endPoint.operations().stream().filter(op1 -> op1.method().is((Object)operation.label())).map(BindingsHandler::opMessage).map(mb -> mb.bindings()).filter(Objects::nonNull).map(mb -> mb.bindings()).flatMap(b -> b.stream()).forEach(mb -> bindingsMap.put(endPoint.path().value(), AsyncMessageBinding.fromMessageBinding(mb)));
    }

    public static Message opMessage(Operation operation) {
        return operation.method().is((Object)AsyncOperation.PUBLISH.label()) ? operation.request() : operation.response();
    }
}

