/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols;

import amf.apicontract.client.platform.model.domain.bindings.anypointmq.AnypointMQChannelBinding;
import amf.apicontract.client.platform.model.domain.bindings.kafka.KafkaChannelBinding;
import amf.apicontract.client.platform.model.domain.bindings.kafka.KafkaMessageBinding;
import amf.apicontract.client.platform.model.domain.bindings.kafka.KafkaOperationBinding;
import amf.apicontract.client.platform.model.domain.bindings.kafka.KafkaServerBinding;
import amf.apicontract.client.platform.model.domain.bindings.solace.SolaceOperationBinding;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.mule.extension.async.apikit.api.attributes.AnypointMQMessageAttributes;
import org.mule.extension.async.apikit.api.attributes.KafkaMessageAttributes;
import org.mule.extension.async.apikit.api.attributes.SalesforcePubSubAttributes;
import org.mule.extension.async.apikit.api.attributes.SolaceMessageAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.MessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.PublishHandler;
import org.mule.extension.async.apikit.internal.protocols.ServerConfig;
import org.mule.extension.async.apikit.internal.protocols.bindings.AsyncChannelBinding;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.client.source.SourceHandler;

public abstract class ProtocolHandler<L extends MessageListenerHandler, P extends PublishHandler> {
    static Pattern NUMBERS_AT_THE_END = Pattern.compile("\\d+$");
    protected Map<Pair<String, String>, SourceHandler> sourceHandlers = new ConcurrentHashMap<Pair<String, String>, SourceHandler>();
    protected Map<Pair<String, String>, L> messageListenerHandlers = new ConcurrentHashMap<Pair<String, String>, L>();
    protected Map<Pair<String, String>, P> publishHandlers = new ConcurrentHashMap<Pair<String, String>, P>();
    protected Map<String, ServerConfig> serverConfigMap = new ConcurrentHashMap<String, ServerConfig>();

    public abstract String getExtensionName();

    public static Protocol protocolByName(String protocol) {
        switch (protocol) {
            case "kafka": 
            case "kafka-secure": {
                return Protocol.KAFKA;
            }
            case "anypointmq": {
                return Protocol.ANYPOINTMQ;
            }
            case "solace": {
                return Protocol.SOLACE;
            }
            case "salesforcepubsub": {
                return Protocol.SALESFORCEPUBSUB;
            }
        }
        throw new AsyncApiModuleException("Protocol '{}' not supported", protocol);
    }

    public static Class<?> messageAttributesByProtocol(Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return KafkaMessageAttributes.class;
            }
            case ANYPOINTMQ: {
                return AnypointMQMessageAttributes.class;
            }
            case SOLACE: {
                return SolaceMessageAttributes.class;
            }
            case SALESFORCEPUBSUB: {
                return SalesforcePubSubAttributes.class;
            }
        }
        throw new AsyncApiModuleException("Protocol '{}' not supported", protocol.toString());
    }

    public abstract void buildMessageListenerHandlersFor(AsyncConfig var1, String var2, String var3, boolean var4, String var5);

    public static Class<?> serverBindingByProtocol(Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return KafkaServerBinding.class;
            }
        }
        throw new AsyncApiModuleException("Server bindings not supported for '{}' protocol", protocol.toString());
    }

    public static Class<?> channelBindingByProtocol(Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return KafkaChannelBinding.class;
            }
            case ANYPOINTMQ: {
                return AnypointMQChannelBinding.class;
            }
        }
        throw new AsyncApiModuleException("Channel bindings not supported for '{}' protocol", protocol.toString());
    }

    public static Class<?> messageBindingByProtocol(Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return KafkaMessageBinding.class;
            }
        }
        throw new AsyncApiModuleException("Message bindings not supported for '{}' protocol", protocol.toString());
    }

    public static Class<?> operatorBindingByProtocol(Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return KafkaOperationBinding.class;
            }
            case SOLACE: {
                return SolaceOperationBinding.class;
            }
        }
        throw new AsyncApiModuleException("Operator bindings not supported for '{}' protocol", protocol.toString());
    }

    public static String stripClassVersioning(String className) {
        return NUMBERS_AT_THE_END.matcher(className).replaceFirst("");
    }

    public abstract void buildPublishHandlersFor(AsyncConfig var1, String var2, String var3);

    public SourceHandler getSourceHandler(String server, String channelName) {
        return this.sourceHandlers.get(new Pair((Object)server, (Object)channelName));
    }

    public L getMessageListenerHandler(String server, String channelName) {
        return (L)((MessageListenerHandler)this.messageListenerHandlers.get(new Pair((Object)server, (Object)channelName)));
    }

    public P getPublishHandler(String server, String channelName) {
        return (P)((PublishHandler)this.publishHandlers.get(new Pair((Object)server, (Object)channelName)));
    }

    public Map<Pair<String, String>, SourceHandler> getSourceHandlers() {
        return this.sourceHandlers;
    }

    protected ServerConfig getServerConfig(List<? extends ServerConfig> serverConfigs, String server) {
        this.serverConfigMap.putIfAbsent(server, serverConfigs.stream().filter(c -> c.getServerKey().equals(server)).findFirst().orElseThrow(() -> new AsyncApiModuleException("No server found with key {}", server)));
        return this.serverConfigMap.get(server);
    }

    protected void applyChannelBindings(AsyncConfig config, String channelName, Protocol protocol) {
        Optional<AsyncChannelBinding> cb = config.getBindingsHandler().getChannelAsyncBinding(channelName, protocol);
        cb.flatMap(AsyncChannelBinding::getBindingChannelName).ifPresent(bindingChannelName -> config.getChannelBasedRegistry().registerChannelBinding((String)bindingChannelName, channelName));
    }

    public static enum Protocol {
        KAFKA,
        ANYPOINTMQ,
        SOLACE,
        SALESFORCEPUBSUB;

    }
}

