/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.parser;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.ResourceLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;

public class APISyncResourceLoader
implements ResourceLoader {
    private final String rootResource;
    private static final String API_SYNC_PROTOCOL = "resource::";

    public APISyncResourceLoader(String mainFile) {
        this.rootResource = mainFile.substring(0, mainFile.lastIndexOf(":") + 1);
    }

    public CompletableFuture<Content> fetch(String resource) {
        CompletableFuture<Content> result = new CompletableFuture<Content>();
        try {
            if (resource == null) {
                result.completeExceptionally(new RuntimeException("Cannot resolve resource null"));
                return result;
            }
            String apiSyncResource = this.toApiSyncResource(resource);
            URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(apiSyncResource);
            String fileContent = this.fileToString(resourceUrl.openConnection().getInputStream());
            result.complete(new Content(fileContent, resourceUrl.toString()));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            return result;
        }
        return result;
    }

    private String fileToString(InputStream inputStream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byteArray = buffer.toByteArray();
            return new String(byteArray, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AsyncApiModuleException(e);
        }
    }

    private String toApiSyncResource(String resource) {
        if (this.isAPISync(resource)) {
            return resource;
        }
        return this.rootResource + resource;
    }

    private boolean isAPISync(String path) {
        return path.startsWith(API_SYNC_PROTOCOL);
    }
}

