/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.operations;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.async.apikit.api.PublishResponse;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.ValidationResult;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.exception.AsyncApiPublishingException;
import org.mule.extension.async.apikit.internal.exception.AsyncApiValidationException;
import org.mule.extension.async.apikit.internal.exception.error.PublishErrorTypeProvider;
import org.mule.extension.async.apikit.internal.metadata.PublishInputTypeResolver;
import org.mule.extension.async.apikit.internal.metadata.PublishMetadataKeyResolver;
import org.mule.extension.async.apikit.internal.operations.PublishParameters;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.bindings.Binding;
import org.mule.extension.async.apikit.internal.validation.AsyncOperation;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishOperation.class);
    protected ComponentLocation componentLocation;

    @Throws(value={PublishErrorTypeProvider.class})
    public void publish(@Config AsyncConfig config, @TypeResolver(value=PublishInputTypeResolver.class) @Content TypedValue<InputStream> content, @MetadataKeyId(value=PublishMetadataKeyResolver.class) @ParameterGroup(name="Publish parameters") PublishParameters parameters, @ConfigOverride boolean disableContentValidation, CompletionCallback<PublishResponse, Void> callback, @DefaultEncoding String defaultEncoding) {
        String serverName = parameters.getServerName();
        ProtocolHandler<?, ?> protocolHandler = config.getHandlerByServer(serverName);
        AsyncApi api = config.getApi();
        if (protocolHandler == null) {
            callback.error((Throwable)((Object)new AsyncApiModuleException("Protocol '{}' is not supported", AsyncApiUtils.getServerProtocol(api, serverName).name())));
            return;
        }
        AMFElementClient amfElementClient = config.getAsyncApiAmfConfiguration().elementClient();
        MediaType mediaType = content.getDataType().getMediaType();
        String runtimeChannel = parameters.getChannelName();
        String specChannel = config.getChannelBasedRegistry().getSpecChannelByRuntimeChannel(runtimeChannel);
        InputStream input = (InputStream)content.getValue();
        if (!disableContentValidation) {
            String mimeType = AsyncApiUtils.getMimeType(AsyncApiUtils.getResolvedMediaType(api, Optional.of(mediaType), defaultEncoding));
            List<AMFShapePayloadValidator> validators = config.getSchemaRegistry().getValidators(api, specChannel, AsyncOperation.SUBSCRIBE, mimeType, amfElementClient);
            List<ValidationResult> results = AsyncApiUtils.validate(validators, runtimeChannel, mimeType, input);
            if (!results.isEmpty()) {
                AsyncApiValidationException e2 = AsyncApiValidationException.fromValidationResults(results);
                LOGGER.warn("Validation failed for channel {}, mediaType {}", new Object[]{runtimeChannel, mimeType, e2});
                callback.error((Throwable)((Object)e2));
                return;
            }
        }
        ExtensionsClient extensionsClient = config.getExtensionsClient();
        protocolHandler.buildPublishHandlersFor(config, serverName, parameters.getChannelName());
        Object publishHandler = protocolHandler.getPublishHandler(serverName, parameters.getChannelName());
        List<Binding> asyncBindings = config.getBindingsHandler().getPublishAsyncBindings(parameters.getChannelName());
        CompletableFuture result = extensionsClient.execute(protocolHandler.getExtensionName(), publishHandler.getPublishOperationName(), publishHandler.configurePublishOperationFor(parameters, (TypedValue<InputStream>)new TypedValue((Object)input, content.getDataType()), asyncBindings));
        try {
            result.handle((r, e) -> {
                if (r != null) {
                    callback.success(publishHandler.handleResult(r));
                } else {
                    callback.error((Throwable)((Object)new AsyncApiPublishingException((Throwable)e)));
                }
                return null;
            });
        }
        catch (Exception e3) {
            LOGGER.warn("Publish operation failed while handling result at {}. channelName={}, location", new Object[]{this.componentLocation.getLocation(), runtimeChannel, e3});
            callback.error((Throwable)((Object)new AsyncApiPublishingException("Publish operation failed while handling result", e3)));
        }
    }
}

