/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal;

import java.util.Collections;
import java.util.List;

public class ValidationResult {
    protected boolean valid;
    protected List<String> errors;
    protected boolean nonRepeatableStream;
    protected Exception exceptionOnValidate;

    protected ValidationResult(boolean valid, List<String> errors, boolean nonRepeatableStream, Exception exceptionOnValidate, Exception exceptionOnRewind) {
        this.valid = valid;
        this.errors = errors;
        this.exceptionOnValidate = exceptionOnValidate;
        this.nonRepeatableStream = nonRepeatableStream;
    }

    public static ValidationResult success() {
        return new ValidationResult(true, Collections.emptyList(), false, null, null);
    }

    public static ValidationResult failure(List<String> errors) {
        return new ValidationResult(false, errors, false, null, null);
    }

    public static ValidationResult invalidStream() {
        return new ValidationResult(false, Collections.emptyList(), true, null, null);
    }

    public static ValidationResult exceptionOnValidation(Exception exceptionOnValidate) {
        return new ValidationResult(false, Collections.emptyList(), false, exceptionOnValidate, null);
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean isNonRepeatableStream() {
        return this.nonRepeatableStream;
    }

    public Exception getExceptionOnValidate() {
        return this.exceptionOnValidate;
    }
}

