/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.operations;

import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.api.PublishResponse;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.InputStreamWrapper;
import org.mule.extension.async.apikit.internal.bindings.AsyncBinding;
import org.mule.extension.async.apikit.internal.bindings.utils.BindingUtils;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.exception.AsyncApiPublishingException;
import org.mule.extension.async.apikit.internal.exception.AsyncApiValidationException;
import org.mule.extension.async.apikit.internal.exception.error.PublishErrorTypeProvider;
import org.mule.extension.async.apikit.internal.metadata.PublishInputTypeResolver;
import org.mule.extension.async.apikit.internal.metadata.PublishMetadataKeyResolver;
import org.mule.extension.async.apikit.internal.operations.PublishParameters;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishOperation.class);

    @Throws(value={PublishErrorTypeProvider.class})
    public void publish(@Config AsyncConfig config, @TypeResolver(value=PublishInputTypeResolver.class) @Content TypedValue<InputStream> content, @MetadataKeyId(value=PublishMetadataKeyResolver.class) @ParameterGroup(name="Publish parameters") PublishParameters parameters, CompletionCallback<PublishResponse, Void> callback, StreamingHelper helper) {
        String serverName = parameters.getServerName();
        ProtocolHandler<?, ?> protocolHandler = config.getHandlerByServer(serverName);
        if (protocolHandler == null) {
            throw new AsyncApiModuleException("Protocol '{}' is not supported", AsyncApiUtils.getServerProtocol(config.getApi(), serverName).name());
        }
        try (InputStreamWrapper inputStreamWrapper = new InputStreamWrapper((InputStream)content.getValue());){
            this.validateMessage(config, parameters, inputStreamWrapper.asString(), content.getDataType().getMediaType());
            ExtensionsClient extensionsClient = config.getExtensionsClient();
            protocolHandler.buildPublishHandlersFor(config, serverName, parameters.getChannelName());
            Object publishHandler = protocolHandler.getPublishHandler(serverName, parameters.getChannelName());
            List<AsyncBinding> asyncBindings = BindingUtils.updatePublisherAsyncBindings(config, parameters.getChannelName());
            CompletableFuture result = extensionsClient.execute(protocolHandler.getExtensionName(), publishHandler.getPublishOperationName(), publishHandler.configurePublishOperationFor(parameters, (TypedValue<InputStream>)new TypedValue((Object)inputStreamWrapper.asInputStream(helper), content.getDataType()), asyncBindings));
            result.handle((r, e) -> {
                if (r != null) {
                    callback.success(publishHandler.handleResult(r));
                } else {
                    callback.error((Throwable)((Object)new AsyncApiPublishingException((Throwable)e)));
                }
                return null;
            });
        }
        catch (IOException e2) {
            throw new AsyncApiPublishingException(e2);
        }
    }

    private void validateMessage(AsyncConfig config, PublishParameters parameters, String content, MediaType mediaType) {
        String mimeType;
        Map<String, AMFShapePayloadValidator> validators = config.getChannelBasedRegistry().getPublishPayloadValidators(config.getApi(), parameters.getChannelName(), config.getAsyncApiAmfConfiguration().elementClient());
        AMFShapePayloadValidator validator = validators.get(mimeType = AsyncApiUtils.getMimeType(AsyncApiUtils.getResolvedMediaType(config.getApi(), Optional.of(mediaType))));
        if (validator == null) {
            LOGGER.warn("Message for '{}' will not be validated", (Object)parameters.getChannelName());
        }
        if (validator != null) {
            try {
                AMFValidationReport report = (AMFValidationReport)validator.validate(content).get();
                if (!report.conforms()) {
                    throw new AsyncApiValidationException("Message content does not conform to schema from spec: \n - {}", report.results().stream().map(AMFValidationResult::message).collect(Collectors.joining("\n - ")));
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AsyncApiValidationException("Error validating message content", e);
            }
        }
    }
}

