/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.execution;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.platform.model.domain.Shape;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import amf.shapes.client.platform.model.domain.ScalarShape;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelBasedRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelBasedRegistry.class);
    private static final String STRING_REGEX = "[a-zA-Z0-9._-]+";
    private ConcurrentMap<String, Pattern> patternsBySpecChannel = new ConcurrentHashMap<String, Pattern>();
    private final Map<String, String> specChannelsByRuntimeChannel = new ConcurrentHashMap<String, String>();
    private final Map<String, Map<String, AMFShapePayloadValidator>> producerValidatorsBySpecChannel = new ConcurrentHashMap<String, Map<String, AMFShapePayloadValidator>>();
    private final Map<String, Map<String, AMFShapePayloadValidator>> consumerValidatorsBySpecChannel = new ConcurrentHashMap<String, Map<String, AMFShapePayloadValidator>>();

    public void registerChannelPatterns(AsyncConfig config) throws InitialisationException {
        if (!this.patternsBySpecChannel.isEmpty()) {
            return;
        }
        try {
            this.patternsBySpecChannel = config.getApi().endPoints().parallelStream().collect(Collectors.toConcurrentMap(ep -> ep.path().value(), ep -> {
                try {
                    return Pattern.compile(this.specChannelToPattern(config, ep.parameters(), ep.path().value()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (Exception e) {
            throw new InitialisationException(e.getCause(), (Initialisable)config);
        }
    }

    public void registerChannelBinding(String overriddenChannelName, String channelName) {
        this.specChannelsByRuntimeChannel.putIfAbsent(overriddenChannelName, channelName);
    }

    public String getSpecChannelByRuntimeChannel(String runtimeChannelName) {
        return this.specChannelsByRuntimeChannel.computeIfAbsent(runtimeChannelName, channel -> this.patternsBySpecChannel.entrySet().parallelStream().filter(entry -> ((Pattern)entry.getValue()).matcher(runtimeChannelName).matches()).findAny().map(Map.Entry::getKey).orElse(runtimeChannelName));
    }

    private String specChannelToPattern(AsyncConfig config, List<Parameter> parameters, String pattern) throws InitialisationException {
        String regex = pattern;
        for (Parameter param : parameters) {
            Shape shape = param.schema();
            if (!(shape instanceof ScalarShape)) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Schema for parameter '%s' is not supported", (Object[])new Object[]{param.name().value()}), (Initialisable)config);
            }
            ScalarShape scalarShape = (ScalarShape)shape;
            String dataType = scalarShape.dataType().value();
            if ((dataType = dataType.substring(dataType.lastIndexOf(35) + 1)).contains("string")) {
                regex = regex.replace("{" + param.name().value() + "}", STRING_REGEX);
                continue;
            }
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Schema type '%s' for parameter '%s' is not supported", (Object[])new Object[]{dataType, param.name().value()}), (Initialisable)config);
        }
        return regex;
    }

    public Map<String, AMFShapePayloadValidator> getPublishPayloadValidators(AsyncApi api, String runtimeChannel, AMFElementClient elementClient) {
        String specChannel = this.getSpecChannelByRuntimeChannel(runtimeChannel);
        if (specChannel == null) {
            LOGGER.warn("Channel '{}' not found in spec while looking for a validator", (Object)runtimeChannel);
            return Collections.emptyMap();
        }
        return this.producerValidatorsBySpecChannel.computeIfAbsent(specChannel, channel -> AsyncApiUtils.getValidatorsForProducerOperation(api, channel, elementClient));
    }

    public Map<String, AMFShapePayloadValidator> getSourcePayloadValidators(AsyncApi api, String specChannel, AMFElementClient elementClient) {
        return this.consumerValidatorsBySpecChannel.computeIfAbsent(specChannel, channel -> AsyncApiUtils.getValidatorsForConsumerOperation(api, channel, elementClient));
    }
}

