/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.bindings.utils;

import amf.apicontract.client.platform.model.domain.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.bindings.AsyncBinding;
import org.mule.extension.async.apikit.internal.bindings.channel.AsyncChannelBinding;
import org.mule.extension.async.apikit.internal.bindings.message.AsyncMessageBinding;

public class BindingUtils {
    public static List<AsyncBinding> updatePublisherAsyncBindings(AsyncConfig config, String channelName) {
        Map<String, AsyncMessageBinding> asyncMessageBindingMap;
        ArrayList<AsyncBinding> asyncBindings = new ArrayList<AsyncBinding>();
        Map<String, AsyncChannelBinding> asyncChannelBindingsMap = config.getBindingsFactory().getAsyncBindingContext().getChannelBindings();
        if (asyncChannelBindingsMap.containsKey(channelName)) {
            asyncBindings.add(asyncChannelBindingsMap.get(channelName));
        }
        if ((asyncMessageBindingMap = config.getBindingsFactory().getAsyncBindingContext().getPublishMessageBindings()).containsKey(channelName)) {
            asyncBindings.add(asyncMessageBindingMap.get(channelName));
        }
        return asyncBindings;
    }

    public static List<AsyncBinding> updateSubscriberAsyncBindings(AsyncConfig config, String channelName) {
        Map<String, AsyncMessageBinding> asyncMessageBindingMap;
        ArrayList<AsyncBinding> asyncBindings = new ArrayList<AsyncBinding>();
        Map<String, AsyncChannelBinding> asyncChannelBindingsMap = config.getBindingsFactory().getAsyncBindingContext().getChannelBindings();
        if (asyncChannelBindingsMap.containsKey(channelName)) {
            AsyncChannelBinding channelBinding = asyncChannelBindingsMap.get(channelName);
            asyncBindings.add(channelBinding);
            if (channelBinding.getBindingChannelName() != null) {
                config.getChannelBasedRegistry().registerChannelBinding(channelBinding.getBindingChannelName(), channelName);
            }
        }
        if ((asyncMessageBindingMap = config.getBindingsFactory().getAsyncBindingContext().getSubscribeMessageBindings()).containsKey(channelName)) {
            asyncBindings.add(asyncMessageBindingMap.get(channelName));
        }
        return asyncBindings;
    }

    public static boolean isPublishOperation(Operation operation) {
        return operation.method().value().equals("publish");
    }
}

