/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.extension.async.apikit.api.attributes.AnypointMQMessageAttributes;
import org.mule.extension.async.apikit.api.attributes.KafkaMessageAttributes;
import org.mule.extension.async.apikit.internal.AsyncConfig;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.MessageListenerHandler;
import org.mule.extension.async.apikit.internal.protocols.PublishHandler;
import org.mule.extension.async.apikit.internal.protocols.ServerConfig;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.client.source.SourceHandler;

public abstract class ProtocolHandler<L extends MessageListenerHandler, P extends PublishHandler> {
    protected Map<Pair<String, String>, SourceHandler> sourceHandlers = new ConcurrentHashMap<Pair<String, String>, SourceHandler>();
    protected Map<Pair<String, String>, L> messageListenerHandlers = new ConcurrentHashMap<Pair<String, String>, L>();
    protected Map<Pair<String, String>, P> publishHandlers = new ConcurrentHashMap<Pair<String, String>, P>();
    protected Map<String, ServerConfig> serverConfigMap = new ConcurrentHashMap<String, ServerConfig>();

    public abstract String getExtensionName();

    public static Protocol protocolByName(String protocol) {
        switch (protocol) {
            case "kafka": 
            case "kafka-secure": {
                return Protocol.KAFKA;
            }
            case "anypointmq": {
                return Protocol.ANYPOINTMQ;
            }
        }
        throw new AsyncApiModuleException("Protocol '{}' not supported", protocol);
    }

    public static Class<?> messageAttributesByProtocol(Protocol protocol) {
        switch (protocol) {
            case KAFKA: {
                return KafkaMessageAttributes.class;
            }
            case ANYPOINTMQ: {
                return AnypointMQMessageAttributes.class;
            }
        }
        throw new AsyncApiModuleException("Protocol '{}' not supported", protocol.toString());
    }

    public abstract void buildMessageListenerHandlersFor(AsyncConfig var1, String var2, String var3);

    public abstract void buildPublishHandlersFor(AsyncConfig var1, String var2, String var3);

    public SourceHandler getSourceHandler(String server, String channelName) {
        return this.sourceHandlers.get(new Pair((Object)server, (Object)channelName));
    }

    public L getMessageListenerHandler(String server, String channelName) {
        return (L)((MessageListenerHandler)this.messageListenerHandlers.get(new Pair((Object)server, (Object)channelName)));
    }

    public P getPublishHandler(String server, String channelName) {
        return (P)((PublishHandler)this.publishHandlers.get(new Pair((Object)server, (Object)channelName)));
    }

    public Map<Pair<String, String>, SourceHandler> getSourceHandlers() {
        return this.sourceHandlers;
    }

    protected ServerConfig getServerConfig(List<? extends ServerConfig> serverConfigs, String server) {
        this.serverConfigMap.putIfAbsent(server, serverConfigs.stream().filter(c -> c.getServerKey().equals(server)).findFirst().orElseThrow(() -> new AsyncApiModuleException("No server found with key {}", server)));
        return this.serverConfigMap.get(server);
    }

    public static enum Protocol {
        KAFKA,
        ANYPOINTMQ;

    }
}

