/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.protocols;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.platform.validation.AMFValidationResult;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.api.attributes.AsyncMessageAttributes;
import org.mule.extension.async.apikit.internal.InputStreamWrapper;
import org.mule.extension.async.apikit.internal.bindings.AsyncBinding;
import org.mule.extension.async.apikit.internal.exception.AsyncApiValidationException;
import org.mule.extension.async.apikit.internal.execution.ChannelBasedRegistry;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.parser.AsyncApiUtils;
import org.mule.extension.async.apikit.internal.sources.RoutingKey;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageListenerHandler<T, A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListenerHandler.class);
    public static final String RESULT_HANDLER_CTX_KEY = "SourceResultHandlerKey";
    protected final AsyncApi api;
    protected final String channelName;
    protected final String serverName;
    protected final SourceCallbackRegistry registry;
    protected final ChannelBasedRegistry channelBasedRegistry;
    protected final AMFElementClient amfElementClient;
    protected final List<AsyncBinding> asyncBindings;
    protected ComponentLocation componentLocation;

    public MessageListenerHandler(AsyncApi api, SourceCallbackRegistry registry, ChannelBasedRegistry channelBasedRegistry, AMFElementClient amfElementClient, String serverName, String channelName, List<AsyncBinding> asyncBindings) {
        this.api = api;
        this.channelName = channelName;
        this.registry = registry;
        this.serverName = serverName;
        this.channelBasedRegistry = channelBasedRegistry;
        this.amfElementClient = amfElementClient;
        this.asyncBindings = asyncBindings;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
    }

    protected abstract String getRuntimeChannelName(Result<T, A> var1);

    public abstract String getSourceListenerName();

    public abstract void configureSourceListener(SourceParameterizer var1);

    protected abstract AsyncMessageAttributes buildResultAttributes(Result<T, A> var1, String var2);

    protected abstract InputStream buildResultOutput(Result<T, A> var1);

    public void consumeSourceListenerResult(SourceResultHandler<T, A> sourceResultHandler) {
        if (sourceResultHandler.getResult() == null) {
            sourceResultHandler.completeWithSuccess(p -> {});
            return;
        }
        String runtimeChannel = this.getRuntimeChannelName(sourceResultHandler.getResult());
        String specChannel = this.channelBasedRegistry.getSpecChannelByRuntimeChannel(runtimeChannel);
        SourceCallback<InputStream, AsyncMessageAttributes> sourceCallback = this.registry.getSourceCallback(new RoutingKey(specChannel));
        if (sourceCallback == null) {
            LOGGER.warn("No source callback found for channel '{}'. The channel does not match any from the ones defined in the spec.", (Object)specChannel);
            sourceResultHandler.completeWithSuccess(p -> {});
            return;
        }
        try (InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(this.buildResultOutput(sourceResultHandler.getResult()));){
            MediaType mediaType = AsyncApiUtils.getResolvedMediaType(this.api, sourceResultHandler.getResult().getMediaType());
            boolean validMessage = this.validateMessage(sourceResultHandler, specChannel, inputStreamWrapper);
            SourceCallbackContext ctx = sourceCallback.createContext();
            ctx.addVariable(RESULT_HANDLER_CTX_KEY, sourceResultHandler);
            if (validMessage) {
                sourceCallback.handle(Result.builder().output((Object)inputStreamWrapper.asInputStream()).mediaType(mediaType).attributes((Object)this.buildResultAttributes(sourceResultHandler.getResult(), specChannel)).build(), ctx);
            } else {
                sourceResultHandler.completeWithSuccess(p -> {});
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in listener handler while processing the message from component location -> {} and channel -> {}", new Object[]{this.componentLocation.getLocation(), runtimeChannel, e});
            sourceResultHandler.completeWithError((Throwable)e, p -> {});
        }
    }

    private boolean validateMessage(SourceResultHandler<T, A> sourceResultHandler, String specChannel, InputStreamWrapper inputStreamWrapper) throws IOException {
        String mimeType = AsyncApiUtils.getMimeType(AsyncApiUtils.getResolvedMediaType(this.api, sourceResultHandler.getResult().getMediaType()));
        AMFShapePayloadValidator validator = this.channelBasedRegistry.getSourcePayloadValidators(this.api, specChannel, this.amfElementClient).get(mimeType);
        if (validator != null) {
            try {
                AMFValidationReport report = (AMFValidationReport)validator.validate(inputStreamWrapper.asString()).get();
                if (!report.conforms()) {
                    String errorDescription = report.results().stream().map(AMFValidationResult::message).collect(Collectors.joining("\n - "));
                    LOGGER.warn("Message content does not conform to schema from spec: \n - {}", (Object)errorDescription);
                    return false;
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new AsyncApiValidationException(e);
            }
        }
        return true;
    }
}

