/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.parser;

import amf.apicontract.client.platform.AMFElementClient;
import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Payload;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.common.validation.ValidationMode;
import amf.core.client.platform.model.StrField;
import amf.core.client.platform.validation.payload.AMFShapePayloadValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.runtime.api.metadata.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncApiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncApiUtils.class);

    public static Optional<Operation> getConsumerOperation(AsyncApi api, String specChannelName) {
        return AsyncApiUtils.getOperation(api, specChannelName, "publish");
    }

    public static Optional<Operation> getProducerOperation(AsyncApi api, String specChannelName) {
        return AsyncApiUtils.getOperation(api, specChannelName, "subscribe");
    }

    public static Map<String, AMFShapePayloadValidator> getValidatorsForConsumerOperation(AsyncApi api, String channelName, AMFElementClient elementClient) {
        return AsyncApiUtils.getValidatorsForOperation(api, channelName, "publish", elementClient, op -> op.request().payloads());
    }

    public static Map<String, AMFShapePayloadValidator> getValidatorsForProducerOperation(AsyncApi api, String channelName, AMFElementClient elementClient) {
        return AsyncApiUtils.getValidatorsForOperation(api, channelName, "subscribe", elementClient, op -> op.response().payloads());
    }

    private static Map<String, AMFShapePayloadValidator> getValidatorsForOperation(AsyncApi api, String specChannelName, String operationName, AMFElementClient elementClient, Function<Operation, List<Payload>> payloadsFunction) {
        Optional<EndPoint> channelEndpoint = api.endPoints().stream().filter(e -> e.path().value().equals(specChannelName)).filter(e -> e.operations().stream().anyMatch(op -> op.method().is((Object)operationName))).findFirst();
        if (!channelEndpoint.isPresent()) {
            LOGGER.warn("Channel '{}' does not have a '{}' operation", (Object)operationName, (Object)specChannelName);
            return Collections.emptyMap();
        }
        EndPoint ep = channelEndpoint.get();
        return ep.operations().stream().filter(op -> op.method().is((Object)operationName)).map(payloadsFunction).flatMap(Collection::stream).collect(Collectors.toMap(p -> p.mediaType().value(), p -> elementClient.payloadValidatorFor(p.schema(), p.mediaType().value(), ValidationMode.StrictValidationMode())));
    }

    private static Optional<Operation> getOperation(AsyncApi api, String specChannelName, String operationName) {
        List operations = api.endPoints().stream().filter(e -> e.path().value().equals(specChannelName)).flatMap(e -> e.operations().stream()).filter(op -> op.method().value().equals(operationName)).collect(Collectors.toList());
        if (operations.isEmpty()) {
            LOGGER.error("No '{}' channel found matching '{}'", (Object)operationName, (Object)specChannelName);
            return Optional.empty();
        }
        if (operations.size() > 1) {
            LOGGER.warn("More than one '{}' channel found matching '{}', the first one will be used.", (Object)operationName, (Object)specChannelName);
        }
        return Optional.of(operations.get(0));
    }

    public static String getMimeType(MediaType mediaType) {
        return mediaType.getPrimaryType() + "/" + mediaType.getSubType();
    }

    public static ProtocolHandler.Protocol getServerProtocol(AsyncApi asyncApi, String server) {
        String protocolName = asyncApi.servers().stream().filter(s -> server.equals(s.name().value())).findAny().orElseThrow(() -> new AsyncApiModuleException("No matching server found in api for server name {}", server)).protocol().value();
        return ProtocolHandler.protocolByName(protocolName);
    }

    public static MediaType getResolvedMediaType(AsyncApi api, Optional<MediaType> resultMediaType) {
        Predicate<MediaType> mediaTypeIsValid = m -> m.equals((Object)MediaType.APPLICATION_JSON) || m.equals((Object)MediaType.APPLICATION_XML);
        if (resultMediaType.isPresent() && mediaTypeIsValid.test(resultMediaType.get())) {
            return resultMediaType.get();
        }
        if (api.contentType() != null && !api.contentType().isEmpty()) {
            return MediaType.parse((String)((StrField)api.contentType().get(0)).value());
        }
        return MediaType.APPLICATION_JSON;
    }
}

