/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal.bindings.factory;

import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.apicontract.client.platform.model.domain.bindings.ChannelBinding;
import amf.apicontract.client.platform.model.domain.bindings.MessageBinding;
import amf.apicontract.client.platform.model.domain.bindings.anypointmq.AnypointMQChannelBinding;
import amf.apicontract.client.platform.model.domain.bindings.anypointmq.AnypointMQMessageBinding;
import amf.apicontract.client.platform.model.domain.bindings.kafka.KafkaMessageBinding;
import java.util.List;
import org.mule.extension.async.apikit.internal.bindings.AsyncBindingContext;
import org.mule.extension.async.apikit.internal.bindings.channel.anypointmq.AnypointMQAsyncChannelBinding;
import org.mule.extension.async.apikit.internal.bindings.message.AsyncMessageBinding;
import org.mule.extension.async.apikit.internal.bindings.message.anypointmq.AnypointMQAsyncMessageBinding;
import org.mule.extension.async.apikit.internal.bindings.message.kafka.KafkaAsyncMessageBinding;
import org.mule.extension.async.apikit.internal.bindings.utils.BindingUtils;
import org.mule.extension.async.apikit.internal.exception.AsyncApiModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindingsFactory.class);
    private final AsyncBindingContext asyncBindingContext = new AsyncBindingContext();

    public BindingsFactory(AsyncApi api) {
        this.buildChannelBindings(api);
        this.buildMessageBindings(api);
    }

    private void buildChannelBindings(AsyncApi api) {
        LOGGER.info("Building Channel bindings");
        api.endPoints().forEach(k -> {
            if (k.bindings() != null && !k.bindings().bindings().isEmpty()) {
                List channelBindings = k.bindings().bindings();
                for (ChannelBinding channelBinding : channelBindings) {
                    if (!(channelBinding instanceof AnypointMQChannelBinding)) continue;
                    AnypointMQAsyncChannelBinding asyncChannelBinding = new AnypointMQAsyncChannelBinding((AnypointMQChannelBinding)channelBinding);
                    k.operations().forEach(op -> this.asyncBindingContext.getChannelBindings().put(k.path().value(), asyncChannelBinding));
                }
            }
        });
    }

    private void buildMessageBindings(AsyncApi api) {
        LOGGER.info("Building Message bindings");
        api.endPoints().forEach(k -> {
            if (!k.operations().isEmpty()) {
                List operations = k.operations();
                for (Operation operation : operations) {
                    Object message = BindingUtils.isPublishOperation(operation) ? operation.request() : operation.response();
                    if (message != null) {
                        if (message.bindings() == null || message.bindings().bindings().isEmpty()) continue;
                        message.bindings().bindings().forEach(messageBinding -> {
                            AsyncMessageBinding asyncMessageBinding = BindingsFactory.getAsyncMessageBinding(messageBinding);
                            if (asyncMessageBinding != null && BindingUtils.isPublishOperation(operation)) {
                                this.asyncBindingContext.getSubscribeMessageBindings().put(k.path().value(), asyncMessageBinding);
                            } else if (asyncMessageBinding != null && !BindingUtils.isPublishOperation(operation)) {
                                this.asyncBindingContext.getPublishMessageBindings().put(k.path().value(), asyncMessageBinding);
                            } else {
                                LOGGER.error("Message binding type is unsupported for binding '{}' within operation '{}' {}", new Object[]{messageBinding.id(), operation.name().value(), operation.method().value()});
                                throw new AsyncApiModuleException("Message binding type is unsupported for binding '{}' within operation '{}' {}", messageBinding.id(), operation.name().value(), operation.method().value());
                            }
                        });
                        continue;
                    }
                    LOGGER.error("Operation type for channelName '{}' not found", (Object)operation.name().value());
                    throw new AsyncApiModuleException("Operation type for channelName '{}' not found", operation.name().value());
                }
            }
        });
    }

    private static AsyncMessageBinding getAsyncMessageBinding(MessageBinding messageBinding) {
        AsyncMessageBinding asyncMessageBinding = null;
        if (messageBinding instanceof AnypointMQMessageBinding) {
            asyncMessageBinding = new AnypointMQAsyncMessageBinding((AnypointMQMessageBinding)messageBinding);
        } else if (messageBinding instanceof KafkaMessageBinding) {
            asyncMessageBinding = new KafkaAsyncMessageBinding((KafkaMessageBinding)messageBinding);
        }
        return asyncMessageBinding;
    }

    public AsyncBindingContext getAsyncBindingContext() {
        return this.asyncBindingContext;
    }
}

