/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.ImmutableFileRepeatableInputStream;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class InputStreamWrapper
implements Closeable {
    private InputStream inputStream;
    private File tempFile;
    private boolean initialized;

    public InputStreamWrapper(InputStream inputStream) {
        this.inputStream = inputStream;
        this.initialized = false;
    }

    public InputStream asInputStream() {
        return this.initialized ? new ImmutableFileRepeatableInputStream(this.tempFile, false) : this.inputStream;
    }

    public InputStream asInputStream(StreamingHelper helper) {
        CursorStream cursorStream = (CursorStream)((CursorProvider)helper.resolveCursorProvider((Object)new ImmutableFileRepeatableInputStream(this.tempFile, false))).openCursor();
        return this.initialized ? cursorStream : this.inputStream;
    }

    public String asString() throws IOException {
        int bytesRead;
        if (this.initialized) {
            return "";
        }
        this.tempFile = File.createTempFile("org.mule.extension.async.apikit.internal", ".tmp");
        BufferedWriter fileWriter = new BufferedWriter(new FileWriter(this.tempFile));
        FileOutputStream tempFileOutputStream = new FileOutputStream(this.tempFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(tempFileOutputStream);
        StringWriter stringWriter = new StringWriter();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inputStream);
        byte[] buffer = new byte[1024];
        while ((bytesRead = bufferedInputStream.read(buffer)) > -1) {
            bufferedOutputStream.write(buffer, 0, bytesRead);
            stringWriter.write(new String(buffer, 0, bytesRead));
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        fileWriter.close();
        tempFileOutputStream.close();
        this.initialized = true;
        return stringWriter.toString();
    }

    @Override
    public void close() {
        if (this.initialized) {
            this.tempFile.delete();
        }
    }
}

