/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.async.apikit.internal;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.APIConfiguration;
import amf.apicontract.client.platform.model.domain.api.AsyncApi;
import amf.core.client.common.transform.PipelineId;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.AMFResult;
import amf.core.client.platform.execution.BaseExecutionEnvironment;
import amf.core.client.platform.execution.ExecutionEnvironment;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.model.document.Document;
import amf.core.client.platform.resource.ResourceLoader;
import amf.core.internal.remote.Spec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extension.async.apikit.internal.bindings.factory.BindingsFactory;
import org.mule.extension.async.apikit.internal.execution.ChannelBasedRegistry;
import org.mule.extension.async.apikit.internal.execution.SourceCallbackRegistry;
import org.mule.extension.async.apikit.internal.operations.PublishOperation;
import org.mule.extension.async.apikit.internal.parser.APISyncResourceLoader;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandler;
import org.mule.extension.async.apikit.internal.protocols.ProtocolHandlerFactory;
import org.mule.extension.async.apikit.internal.protocols.amq.AnypointMQConfig;
import org.mule.extension.async.apikit.internal.protocols.kafka.KafkaConfig;
import org.mule.extension.async.apikit.internal.sources.AsyncMessageListenerSource;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.source.SourceHandler;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactConstants;

@Operations(value={PublishOperation.class})
@Sources(value={AsyncMessageListenerSource.class})
public class AsyncConfig
implements Lifecycle {
    @Parameter
    @Summary(value="API definition")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Path
    private String apiDefinition;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of Kafka configurations")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<KafkaConfig> kafkaConfigs;
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="List of AMQ configurations")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<AnypointMQConfig> anypointMQConfigs;
    @Inject
    private ExtensionsClient extensionsClient;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    private AsyncApi api;
    private SourceCallbackRegistry sourceCallbackRegistry;
    private AMFConfiguration asyncApiAmfConfiguration;
    private ChannelBasedRegistry channelBasedRegistry;
    private Map<String, ProtocolHandler<?, ?>> protocolHandlers;
    private BindingsFactory bindingsFactory;

    public void initialise() throws InitialisationException {
        ArtifactConstants.getApiClassifiers().add("evented-api");
        this.api = this.parseApi(this.apiDefinition);
        this.scheduler = this.getScheduler();
        this.sourceCallbackRegistry = new SourceCallbackRegistry();
        this.channelBasedRegistry = new ChannelBasedRegistry();
        this.buildProtocolHandlers();
        this.bindingsFactory = new BindingsFactory(this.api);
    }

    public void dispose() {
        this.scheduler.shutdownNow();
        for (ProtocolHandler<?, ?> protocolHandler : this.protocolHandlers.values()) {
            Map<Pair<String, String>, SourceHandler> sourceHandlers = protocolHandler.getSourceHandlers();
            sourceHandlers.values().forEach(SourceHandler::dispose);
        }
        ArtifactConstants.getApiClassifiers().remove("evented-api");
    }

    public void start() throws MuleException {
        this.channelBasedRegistry.registerChannelPatterns(this);
    }

    public void stop() throws MuleException {
    }

    private Scheduler getScheduler() {
        return this.schedulerService.cpuIntensiveScheduler();
    }

    public String getApiDefinition() {
        return this.apiDefinition;
    }

    public ExtensionsClient getExtensionsClient() {
        return this.extensionsClient;
    }

    public List<KafkaConfig> getKafkaConfigs() {
        return this.kafkaConfigs;
    }

    public List<AnypointMQConfig> getAnyPointMQConfigs() {
        return this.anypointMQConfigs;
    }

    public SourceCallbackRegistry getSourceCallbackRegistry() {
        return this.sourceCallbackRegistry;
    }

    public BindingsFactory getBindingsFactory() {
        return this.bindingsFactory;
    }

    public AsyncApi getApi() {
        return this.api;
    }

    public ChannelBasedRegistry getChannelBasedRegistry() {
        return this.channelBasedRegistry;
    }

    public AsyncApi parseApi(String api) throws InitialisationException {
        try {
            ExecutionEnvironment executionEnv = new ExecutionEnvironment((ScheduledExecutorService)this.scheduler);
            APISyncResourceLoader apiSyncResourceLoader = new APISyncResourceLoader(api);
            AMFConfiguration amfConfiguration = APIConfiguration.API().withResourceLoader((ResourceLoader)apiSyncResourceLoader).withExecutionEnvironment((BaseExecutionEnvironment)executionEnv);
            AMFBaseUnitClient amfBaseUnitClient = amfConfiguration.baseUnitClient();
            AMFParseResult parseResult = (AMFParseResult)amfBaseUnitClient.parse(api).get();
            BaseUnit model = parseResult.baseUnit();
            if (!parseResult.conforms()) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"API does not conform with AsyncAPI spec"), (Initialisable)this);
            }
            Spec spec = parseResult.sourceSpec();
            this.asyncApiAmfConfiguration = APIConfiguration.fromSpec((Spec)spec).withResourceLoader((ResourceLoader)apiSyncResourceLoader).withExecutionEnvironment((BaseExecutionEnvironment)executionEnv);
            AMFResult transformResult = this.asyncApiAmfConfiguration.baseUnitClient().transform(model, PipelineId.Editing());
            return (AsyncApi)((Document)transformResult.baseUnit()).encodes();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public AMFConfiguration getAsyncApiAmfConfiguration() {
        return this.asyncApiAmfConfiguration;
    }

    public ProtocolHandler<?, ?> getHandlerByServer(String server) {
        return this.protocolHandlers.get(server);
    }

    private void buildProtocolHandlers() {
        ProtocolHandler<?, ?> protocolHandler;
        this.protocolHandlers = new HashMap();
        ProtocolHandlerFactory protocolHandlerFactory = new ProtocolHandlerFactory();
        if (!this.kafkaConfigs.isEmpty()) {
            protocolHandler = protocolHandlerFactory.buildProtocolHandler(ProtocolHandler.Protocol.KAFKA);
            this.protocolHandlers.putAll((Map)this.kafkaConfigs.parallelStream().collect(Collectors.toConcurrentMap(KafkaConfig::getServerKey, kafkaConfig -> protocolHandler)));
        }
        if (!this.anypointMQConfigs.isEmpty()) {
            protocolHandler = protocolHandlerFactory.buildProtocolHandler(ProtocolHandler.Protocol.ANYPOINTMQ);
            this.protocolHandlers.putAll((Map)this.anypointMQConfigs.parallelStream().collect(Collectors.toConcurrentMap(AnypointMQConfig::getServerKey, amqConfig -> protocolHandler)));
        }
    }
}

