/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.jirarest.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.MetaDataKeyProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.devkit.3.6.1.shade.metadata.MetaDataGeneratorUtils;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.jira.api.rest.JiraClientAuthenticationException;
import org.mule.modules.jirarest.JiraRestConnector;
import org.mule.security.oauth.callback.ProcessCallback;

public class IssuesNotifyMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object entityType;
    protected String _entityTypeType;
    protected Object issueKeyOrId;
    protected String _issueKeyOrIdType;
    protected Object payload;
    protected Map<String, Object> _payloadType;

    public IssuesNotifyMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setPayload(Object value) {
        this.payload = value;
    }

    public void setEntityType(Object value) {
        this.entityType = value;
    }

    public void setIssueKeyOrId(Object value) {
        this.issueKeyOrId = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedEntityType = (String)this.evaluateAndTransform(this.getMuleContext(), event, IssuesNotifyMessageProcessor.class.getDeclaredField("_entityTypeType").getGenericType(), null, this.entityType);
        final String _transformedIssueKeyOrId = (String)this.evaluateAndTransform(this.getMuleContext(), event, IssuesNotifyMessageProcessor.class.getDeclaredField("_issueKeyOrIdType").getGenericType(), null, this.issueKeyOrId);
        final Map _transformedPayload = (Map)this.evaluateAndTransform(this.getMuleContext(), event, IssuesNotifyMessageProcessor.class.getDeclaredField("_payloadType").getGenericType(), null, this.payload);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(JiraClientAuthenticationException.class);
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                ((JiraRestConnector)object).issuesNotify(_transformedEntityType, _transformedIssueKeyOrId, _transformedPayload);
                return null;
            }
        }, (MessageProcessor)this, event);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        if (this.entityType == null || this.entityType.toString() == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving metadata from parameter: entityType at processor issuesNotify at module JiraRestConnector");
        }
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey(this.entityType.toString(), null);
        metaDataKey.setCategory("NotifyCategory");
        metaDataKey.addProperty((MetaDataKeyProperty)new TypeDescribingProperty(TypeDescribingProperty.TypeScope.INPUT, "issuesNotify"));
        Result<MetaData> genericMetaData = this.getGenericMetaData((MetaDataKey)metaDataKey);
        if (Result.Status.FAILURE.equals((Object)genericMetaData.getStatus())) {
            return genericMetaData;
        }
        MetaDataModel wrappedMetaDataModel = ((MetaData)genericMetaData.get()).getPayload();
        return new DefaultResult((Object)MetaDataGeneratorUtils.extractPropertiesToMetaData(wrappedMetaDataModel, (MetaData)genericMetaData.get()));
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult((Object)new DefaultMetaData(this.getPojoOrSimpleModel(Void.TYPE)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at JiraRestConnector at issuesNotify retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

