/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.jirarest.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.filter.EncodingFilter;
import org.glassfish.jersey.jackson1.Jackson1Feature;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.mule.module.jira.api.rest.JiraClientAuthenticationException;
import org.mule.modules.jirarest.ConnectorConnectionStrategy;
import org.mule.modules.jirarest.client.JiraClientException;
import org.mule.modules.jirarest.client.RedirectFilter;
import org.mule.modules.jirarest.client.RestIssueClient;

public class JiraClient {
    private Client client;
    private String baseUrl;
    private RestIssueClient issueClient;
    private static final Logger log = Logger.getLogger(JiraClient.class);

    public JiraClient(ConnectorConnectionStrategy strategy) {
        HttpAuthenticationFeature httpAuthenticationFeature = HttpAuthenticationFeature.basic((String)strategy.getUsername(), (String)strategy.getPassword());
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(Jackson1Feature.class).register(EncodingFilter.class).register(GZipEncoder.class).register(DeflateEncoder.class).register(RedirectFilter.class).register((Object)httpAuthenticationFeature);
        this.client = ClientBuilder.newClient((Configuration)clientConfig);
        this.baseUrl = strategy.getServerUrl();
        this.issueClient = new RestIssueClient(this);
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public RestIssueClient getIssueClient() {
        return this.issueClient;
    }

    public void setIssueClient(RestIssueClient issueClient) {
        this.issueClient = issueClient;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public WebTarget getTarget(URI uri) {
        return this.client.target(this.baseUrl + uri);
    }

    private <T> T genericHttpRequest(HttpMethod httpMethod, String url, Object objectRequest, GenericType<T> type) {
        URI uri = UriBuilder.fromUri((String)url).build(new Object[0]);
        Invocation.Builder builder = this.getTarget(uri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        Response response = null;
        switch (httpMethod) {
            case POST: {
                response = builder.post(Entity.entity((Object)objectRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                break;
            }
            case PUT: {
                response = builder.put(Entity.entity((Object)objectRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                break;
            }
            case DELETE: {
                response = builder.delete();
                break;
            }
            default: {
                response = builder.get();
            }
        }
        return this.handleResponse(response, type);
    }

    public Map<String, Object> genericHttpRequestMap(HttpMethod httpMethod, String url, Object objectRequest) {
        return this.genericHttpRequest(httpMethod, url, objectRequest, new GenericType<Map<String, Object>>(){});
    }

    public List<Map<String, Object>> genericHttpRequestList(HttpMethod httpMethod, String url, Object objectRequest) {
        return this.genericHttpRequest(httpMethod, url, objectRequest, new GenericType<List<Map<String, Object>>>(){});
    }

    public Object genericHttpRequestObject(HttpMethod httpMethod, String url, Object objectRequest) {
        return this.genericHttpRequest(httpMethod, url, objectRequest, new GenericType<Object>(){});
    }

    public <T> T get(WebTarget target, Class<T> returnClass) {
        Response response = target.request(new String[]{"application/json"}).get();
        return this.handleResponse(response, returnClass);
    }

    public <T> T get(WebTarget target, GenericType<T> returnGenericType) {
        Response response = target.request(new String[]{"application/json"}).get();
        return this.handleResponse(response, returnGenericType);
    }

    public <T> T post(WebTarget target, Class<T> returnClass, Object requestObject) {
        Response response = target.request(new String[]{"application/json"}).post(Entity.entity((Object)requestObject, (String)"application/json"));
        return this.handleResponse(response, returnClass);
    }

    public <T> T put(WebTarget target, Class<T> returnClass, Object requestObject) {
        Response response = target.request(new String[]{"application/json"}).put(Entity.entity((Object)requestObject, (String)"application/json"));
        return this.handleResponse(response, returnClass);
    }

    protected void delete(WebTarget target) {
        Response response = target.request().delete();
        this.handleResponse(response);
    }

    private <T> T handleResponse(Response response, Class<T> returnClass) {
        if (response.getStatus() == 200) {
            return (T)response.readEntity(returnClass);
        }
        this.handleResponse(response);
        return null;
    }

    private <T> T handleResponse(Response response, GenericType<T> returnGenericType) {
        if (response.getStatus() == 204) {
            return null;
        }
        if (response.getStatus() >= 200 && response.getStatus() < 300) {
            try {
                return (T)response.readEntity(returnGenericType);
            }
            catch (IllegalStateException | ProcessingException e) {
                log.warn((Object)"No content returned");
                return null;
            }
        }
        this.handleResponse(response);
        return null;
    }

    private void handleResponse(Response response) {
        if (response.getStatus() >= 200 && response.getStatus() < 300) {
            return;
        }
        if (response.getStatus() == 400 || response.getStatus() == 404) {
            log.warn((Object)("STATUS: " + response.getStatus()));
            log.warn((Object)("MESSAGE: " + (String)response.readEntity(String.class)));
            return;
        }
        if (response.getStatus() == 401 || response.getStatus() == 403) {
            log.error((Object)("STATUS: " + response.getStatus()));
            log.error((Object)("MESSAGE: " + (String)response.readEntity(String.class)));
            throw new JiraClientAuthenticationException();
        }
        if (response.getStatus() == 500) {
            log.error((Object)("STATUS: " + response.getStatus()));
            log.error((Object)("MESSAGE: " + (String)response.readEntity(String.class)));
            throw new JiraClientException(response.getStatus(), (String)response.readEntity(String.class));
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

