/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.jirarest;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.mule.module.jira.api.rest.JiraRestClientCallWrapper;
import org.mule.module.jira.api.rest.JiraRestClientInvocation;
import org.mule.modules.jirarest.ConnectorConnectionStrategy;
import org.mule.modules.jirarest.client.JiraClient;
import org.mule.modules.jirarest.model.Attachment;

public class JiraRestConnector {
    private ConnectorConnectionStrategy strategy;
    private String issueKey;

    public ConnectorConnectionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ConnectorConnectionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    public String getIssueKey() {
        return this.issueKey;
    }

    public Object aGenericRestRequest(JiraClient.HttpMethod httpMethod, String url, Map<String, Object> body) {
        return this.strategy.getJiraClient().genericHttpRequestObject(httpMethod, url, body);
    }

    public Map<String, Object> myself() {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/myself");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void attachmentsAddAttachment(String issueKeyOrId, final InputStream in, final String filename) {
        final URI attachmentsUri = UriBuilder.fromUri((String)this.strategy.getServerUrl()).path("/rest/api/2/issue/{issueKeyOrId}/attachments").build(new Object[]{issueKeyOrId});
        JiraRestClientCallWrapper.wrap(new JiraRestClientInvocation<Void>(){

            @Override
            public Void invoke() {
                JiraRestConnector.this.strategy.getJiraRestClient().getIssueClient().addAttachment(attachmentsUri, in, filename).claim();
                return null;
            }
        });
    }

    public InputStream attachmentsGetAttachment(String attachmentLink) {
        final URI attachmentUri = UriBuilder.fromUri((String)attachmentLink).build(new Object[0]);
        return JiraRestClientCallWrapper.wrap(new JiraRestClientInvocation<InputStream>(){

            @Override
            public InputStream invoke() {
                return (InputStream)JiraRestConnector.this.strategy.getJiraRestClient().getIssueClient().getAttachment(attachmentUri).claim();
            }
        });
    }

    public List<Attachment> attachmentsGetAttachmentsFromIssue(String issueKeyOrId) {
        return this.strategy.getJiraClient().getIssueClient().getAttachments(issueKeyOrId);
    }

    public Map<String, Object> componentsCreateComponent(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/component");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> componentsUpdateComponent(String entityType, String id, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/component").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public Map<String, Object> componentsGetComponent(String entityType, String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/component").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void componentsDeleteComponent(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/component").path(id);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> groupsGetGroup(String entityType, String groupName, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/group").queryParam("groupname", new Object[]{groupName});
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void groupsDeleteGroup(String groupName, String swapGroup) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/group").queryParam("groupname", new Object[]{groupName});
        if (swapGroup != null) {
            builder = builder.queryParam("swapGroup", new Object[]{swapGroup});
        }
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> groupsCreateGroup(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/group");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public void groupsAddUserToGroup(String groupName, String user) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("name", user);
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/group/user").queryParam("groupname", new Object[]{groupName});
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public void groupsDeleteUserFromGroup(String groupName, String user) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/group/user").queryParam("groupname", new Object[]{groupName}).queryParam("username", new Object[]{user});
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesIssueCreate(String entityType, Map<String, Object> payload) {
        String url = "/rest/api/2/issue";
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, "/rest/api/2/issue", payload);
    }

    public Map<String, Object> issuesIssueGetUpdate(String entityType, String issueKeyOrId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public Map<String, Object> issuesIssueGet(String entityType, String issueKeyOrId, String fields, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId);
        if (fields != null) {
            builder = builder.queryParam("fields", new Object[]{fields});
        }
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void issuesIssueDelete(String issueKeyOrId, Boolean deleteSubtasks) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId);
        if (deleteSubtasks != null && deleteSubtasks.booleanValue()) {
            builder = builder.queryParam("deleteSubtasks", new Object[]{"true"});
        }
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public void issuesAssignee(String entityType, String issueKeyOrId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("assignee");
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public Map<String, Object> issuesCommentsGet(String entityType, String issueKeyOrId, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("comment");
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesCommentGet(String entityType, String issueKeyOrId, String commentId, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("comment").path(commentId);
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesCommentAdd(String entityType, String issueKeyOrId, Map<String, Object> payload, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("comment");
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> issuesCommentUpdate(String entityType, String issueKeyOrId, String commentId, Map<String, Object> payload, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("comment").path(commentId);
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public void issuesCommentDelete(String issueKeyOrId, String commentId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("comment").path(commentId);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesIssueMetadataGet(String entityType, String issueKeyOrId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("editmeta");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void issuesNotify(String entityType, String issueKeyOrId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("notify");
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> issuesTransitionsGet(String entityType, String issueKeyOrId, String transitionId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("transitions");
        if (transitionId != null) {
            builder = builder.queryParam("transitionId", new Object[]{transitionId});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void issuesTransitionPerform(String entityType, String issueKeyOrId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("transitions");
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public List<Map<String, Object>> issuesRemoteLinksGet(String entityType, String issueKeyOrId, String globalId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("remotelink");
        if (globalId != null) {
            builder = builder.queryParam("globalId", new Object[]{globalId});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesRemoteLinkCreate(String entityType, String issueKeyOrId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("remotelink");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> issuesRemoteLinkGet(String entityType, String issueKeyOrId, String linkId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("remotelink").path(linkId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void issuesRemoteLinkUpdate(String entityType, String issueKeyOrId, String linkId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("remotelink").path(linkId);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public void issuesRemoteLinkDelete(String issueKeyOrId, String linkId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("remotelink").path(linkId);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesVotesGet(String entityType, String issueKeyOrId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("votes");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesVoteAdd(String issueKeyOrId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("votes");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, null);
    }

    public void issuesVoteDelete(String issueKeyOrId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("votes");
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesWatchersGet(String entityType, String issueKeyOrId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("watchers");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void issuesWatcherCreate(String issueKeyOrId, String user) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("watchers");
        String url = builder.build(new Object[0]).toString();
        String userParam = user;
        if (!user.contains("\"")) {
            userParam = "\"" + user + "\"";
        }
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, userParam);
    }

    public void issuesWatcherDelete(String issueKeyOrId, String user) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("watchers");
        builder = builder.queryParam("username", new Object[]{user});
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesWorklogsGet(String entityType, String issueKeyOrId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("worklog");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesWorklogCreate(String entityType, String issueKeyOrId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("worklog");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> issuesWorklogGet(String entityType, String issueKeyOrId, String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("worklog").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesWorklogUpdate(String entityType, String issueKeyOrId, String id, Map<String, Object> payload, String adjustEstimate, String newEstimate) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("worklog").path(id);
        if (adjustEstimate != null) {
            builder = builder.queryParam("adjustEstimate", new Object[]{adjustEstimate});
        }
        if (newEstimate != null) {
            builder = builder.queryParam("newEstimate", new Object[]{newEstimate});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public void issuesWorklogDelete(String issueKeyOrId, String id, String adjustEstimate, String newEstimate, String increaseBy) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path(issueKeyOrId).path("worklog").path(id);
        if (adjustEstimate != null) {
            builder = builder.queryParam("adjustEstimate", new Object[]{adjustEstimate});
        }
        if (newEstimate != null) {
            builder = builder.queryParam("newEstimate", new Object[]{newEstimate});
        }
        if (increaseBy != null) {
            builder = builder.queryParam("increaseBy", new Object[]{increaseBy});
        }
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesCreateMetaGet(String entityType, String projectIds, String projectKeys, String issueTypeIds, String issueTypeNames) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issue").path("createmeta");
        if (projectIds != null) {
            builder = builder.queryParam("projectIds", new Object[]{projectIds});
        }
        if (projectKeys != null) {
            builder = builder.queryParam("projectKeys", new Object[]{projectKeys});
        }
        if (issueTypeIds != null) {
            builder = builder.queryParam("issuetypeIds", new Object[]{issueTypeIds});
        }
        if (issueTypeNames != null) {
            builder = builder.queryParam("issuetypeNames", new Object[]{issueTypeNames});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesIssueLinkCreate(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLink");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> issuesIssueLinkGet(String entityType, String linkId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLink").path(linkId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void issuesIssueLinkDelete(String linkId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLink").path(linkId);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> issuesIssueLinkTypesGet(String entityType) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLinkType");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesIssueLinkTypeGet(String entityType, String issueLinkTypeId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLinkType").path(issueLinkTypeId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesIssueLinkTypeCreate(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLinkType");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> issuesIssueLinkTypeUpdate(String entityType, String issueLinkTypeId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLinkType").path(issueLinkTypeId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public void issuesIssueLinkTypeDelete(String issueLinkTypeId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issueLinkType").path(issueLinkTypeId);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public List<Map<String, Object>> issuesIssueTypesGet(String entityType) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issuetype");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesIssueTypeGet(String entityType, String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/issuetype").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> issuesPrioritiesGet(String entityType) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/priority");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesPriorityGet(String entityType, String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/priority").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> issuesStatusesGet(String entityType) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/status");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> issuesStatusGet(String entityType, String idOrName) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/status").path(idOrName);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> projectsProjectsGet(String entityType) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/project");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> projectsProjectGet(String entityType, String projectIdOrKey) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/project").path(projectIdOrKey);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> projectsComponentsGet(String entityType, String projectIdOrKey) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/project").path(projectIdOrKey).path("components");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> projectsStatusesGet(String entityType, String projectIdOrKey) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/project").path(projectIdOrKey).path("statuses");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> projectsVersionsGet(String entityType, String projectIdOrKey) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/project").path(projectIdOrKey).path("versions");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> projectCategoriesGet(String entityType) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/projectCategory");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> projectCategoryCreate(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/projectCategory");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> projectCategoryGet(String entityType, String categoryId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/projectCategory").path(categoryId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> projectCategoryUpdate(String entityType, String categoryId, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/projectCategory").path(categoryId);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public void projectCategoryDelete(String categoryId) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/projectCategory").path(categoryId);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public Map<String, Object> search(String entityType, String jql, String startAt, String maxResults, Boolean validateQuery, String fields, String expand) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/search").queryParam("jql", new Object[]{jql});
        if (startAt != null) {
            builder = builder.queryParam("startAt", new Object[]{startAt});
        }
        if (maxResults != null) {
            builder = builder.queryParam("maxResults", new Object[]{maxResults});
        }
        if (validateQuery != null && validateQuery.booleanValue()) {
            builder = builder.queryParam("validateQuery", new Object[]{"true"});
        }
        if (fields != null) {
            builder = builder.queryParam("fields", new Object[]{fields});
        }
        if (expand != null) {
            builder = builder.queryParam("expand", new Object[]{expand});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> userGet(String entityType, String user, String key) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user");
        if (user != null) {
            builder = builder.queryParam("username", new Object[]{user});
        }
        if (key != null) {
            builder = builder.queryParam("key", new Object[]{key});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> userUpdate(String entityType, Map<String, Object> payload, String username, String key) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user");
        if (username != null) {
            builder = builder.queryParam("username", new Object[]{username});
        }
        if (key != null) {
            builder = builder.queryParam("key", new Object[]{key});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public Map<String, Object> userCreate(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public void userDelete(String user, String key) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user");
        if (user != null) {
            builder = builder.queryParam("username", new Object[]{user});
        }
        if (key != null) {
            builder = builder.queryParam("key", new Object[]{key});
        }
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }

    public List<Map<String, Object>> userGetAssignable(String entityType, String user, String project, String issueKey, String startAt, String maxResults) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user/assignable/search");
        if (user != null) {
            builder = builder.queryParam("username", new Object[]{user});
        }
        if (project != null) {
            builder = builder.queryParam("project", new Object[]{project});
        }
        if (issueKey != null) {
            builder = builder.queryParam("issueKey", new Object[]{issueKey});
        }
        if (startAt != null) {
            builder = builder.queryParam("startAt", new Object[]{startAt});
        }
        if (maxResults != null) {
            builder = builder.queryParam("maxResults", new Object[]{maxResults});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> userGetAssignableProject(String entityType, String user, String projectKeys, String startAt, String maxResults) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user/assignable/multiProjectSearch");
        if (user != null) {
            builder = builder.queryParam("username", new Object[]{user});
        }
        if (projectKeys != null) {
            builder = builder.queryParam("projectKeys", new Object[]{projectKeys});
        }
        if (startAt != null) {
            builder = builder.queryParam("startAt", new Object[]{startAt});
        }
        if (maxResults != null) {
            builder = builder.queryParam("maxResults", new Object[]{maxResults});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public List<Map<String, Object>> userSearch(String entityType, String user, String startAt, String maxResults, Boolean includeActive, Boolean includeInactive) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/user/search");
        if (user != null) {
            builder = builder.queryParam("username", new Object[]{user});
        }
        if (startAt != null) {
            builder = builder.queryParam("startAt", new Object[]{startAt});
        }
        if (maxResults != null) {
            builder = builder.queryParam("maxResults", new Object[]{maxResults});
        }
        if (includeActive != null) {
            builder = builder.queryParam("includeActive", new Object[]{"true"});
        }
        if (includeInactive != null) {
            builder = builder.queryParam("includeInactive", new Object[]{"true"});
        }
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestList(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> versionCreate(String entityType, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/version");
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.POST, url, payload);
    }

    public Map<String, Object> versionGet(String entityType, String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/version").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public Map<String, Object> versionUpdate(String entityType, String id, Map<String, Object> payload) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/version").path(id);
        String url = builder.build(new Object[0]).toString();
        return this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.PUT, url, payload);
    }

    public void versionDelete(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/version").path(id);
        String url = builder.build(new Object[0]).toString();
        this.strategy.getJiraClient().genericHttpRequestMap(JiraClient.HttpMethod.DELETE, url, null);
    }
}

