/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.jirarest;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.UriBuilder;
import org.apache.log4j.Logger;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.module.jira.api.rest.JiraClientAuthenticationException;
import org.mule.modules.jirarest.client.JiraClient;

public class ConnectorConnectionStrategy {
    private static final Logger log = Logger.getLogger(JiraClient.class);
    private JiraRestClient jiraRestClient;
    private JiraClient jiraClient;
    private String username;
    private String password;
    private String serverUrl;

    public void connect(String username, String password, String serverUrl) throws ConnectionException {
        this.username = username;
        this.password = password;
        this.serverUrl = serverUrl;
        if (serverUrl != null) {
            AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
            try {
                URI jiraServerUri = new URI(serverUrl);
                this.jiraRestClient = factory.createWithBasicHttpAuthentication(jiraServerUri, username, password);
                this.jiraClient = new JiraClient(this);
                Map<String, Object> response = this.myself();
                if (response.get("key") != null) {
                    return;
                }
                throw new JiraClientAuthenticationException();
            }
            catch (JiraClientAuthenticationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "", "Invalid credentials");
            }
            catch (ProcessingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "", "Invalid server url provided");
            }
            catch (URISyntaxException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "", "Invalid server url provided");
            }
        }
    }

    private Map<String, Object> myself() {
        UriBuilder builder = UriBuilder.fromPath((String)"/rest/api/2/myself/");
        String url = builder.build(new Object[0]).toString();
        return this.jiraClient.genericHttpRequestMap(JiraClient.HttpMethod.GET, url, null);
    }

    public void disconnect() throws RuntimeException {
        this.username = null;
        this.password = null;
        this.serverUrl = null;
        this.jiraClient = null;
        if (this.jiraRestClient != null) {
            try {
                this.jiraRestClient.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.jiraRestClient = null;
        }
    }

    public boolean isConnected() {
        return this.jiraClient != null;
    }

    public String connectionId() {
        return "{username = '" + this.username + "', baseUrl = '" + this.serverUrl + "'}";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public JiraClient getJiraClient() {
        return this.jiraClient;
    }

    public JiraRestClient getJiraRestClient() {
        return this.jiraRestClient;
    }
}

