/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.api.rest;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.google.common.base.Optional;
import org.mule.module.jira.api.rest.JiraClientAuthenticationException;
import org.mule.module.jira.api.rest.JiraClientAuthorizationException;
import org.mule.module.jira.api.rest.JiraClientOperationNotSupportedException;
import org.mule.module.jira.api.rest.JiraClientRequestException;
import org.mule.module.jira.api.rest.JiraRestClientInvocation;

public abstract class JiraRestClientCallWrapper {
    private static final int BAD_REQUEST = 400;
    private static final int UNAUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;

    private JiraRestClientCallWrapper() {
    }

    public static <T> T wrap(JiraRestClientInvocation<T> invocation) {
        try {
            return invocation.invoke();
        }
        catch (RestClientException e) {
            Optional status = e.getStatusCode();
            if (status.isPresent()) {
                switch ((Integer)status.get()) {
                    case 401: {
                        throw new JiraClientAuthenticationException(e);
                    }
                    case 403: {
                        throw new JiraClientAuthorizationException(e);
                    }
                    case 400: {
                        throw new JiraClientRequestException(e);
                    }
                    case 404: {
                        return null;
                    }
                }
                throw e;
            }
            throw new JiraClientOperationNotSupportedException(e);
        }
    }
}

