/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.api.datasense;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Iterator;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.ListMetaDataBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.module.jira.api.rest.JiraRestConnectorException;
import org.mule.modules.jirarest.JiraRestConnector;

public class JiraMetaDataBuilder {
    private JiraRestConnector connector;

    public JiraMetaDataBuilder(JiraRestConnector connector) {
        this.connector = connector;
    }

    public MetaDataModel build(String entityId) throws IOException, JSONException, JiraRestConnectorException {
        Object json;
        String jsonString = this.retrieveDynamicContentForEntity(entityId);
        if (jsonString == null) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(entityId + ".json");
            jsonString = IOUtils.toString((InputStream)in);
        }
        if ((json = new JSONTokener(jsonString).nextValue()) instanceof JSONObject) {
            JSONObject jo = (JSONObject)json;
            DynamicObjectBuilder builder = new DefaultMetaDataBuilder().createDynamicObject(entityId);
            this.visit(jo, builder, entityId);
            return builder.build();
        }
        if (json instanceof JSONArray) {
            JSONArray ja = (JSONArray)json;
            ListMetaDataBuilder builder = new DefaultMetaDataBuilder().createList();
            this.visit(ja, builder, entityId);
            return builder.build();
        }
        return null;
    }

    private void visit(JSONObject jo, DynamicObjectBuilder<?> builder, String prefix) {
        Iterator keys = jo.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String keyNext = prefix + " > " + key;
            JSONArray jsonArray = jo.optJSONArray(key);
            JSONObject jsonObject = jo.optJSONObject(key);
            String jsonString = jo.optString(key);
            if (jsonArray != null) {
                this.visit(jsonArray, builder.addList(key), keyNext);
                continue;
            }
            if (jsonObject != null) {
                this.visit(jsonObject, (DynamicObjectBuilder<?>)builder.addDynamicObjectField(key), keyNext);
                continue;
            }
            if (jsonString == null) continue;
            builder.addSimpleField(key, DataType.STRING).setDescription(jsonString).setExample(jsonString).setLabel(key);
        }
    }

    private Object visit(JSONArray ja, ListMetaDataBuilder<?> listBuilder, String prefix) {
        if (ja.length() > 0) {
            JSONObject jsonObject = ja.optJSONObject(0);
            JSONArray jsonArray = ja.optJSONArray(0);
            String jsonString = ja.optString(0);
            if (jsonObject != null) {
                DynamicObjectBuilder builder = listBuilder.ofDynamicObject(prefix);
                this.visit(jsonObject, builder, prefix);
                builder.endDynamicObject();
            } else if (jsonArray != null) {
                ListMetaDataBuilder ofList = listBuilder.ofList();
                this.visit(jsonArray, ofList, prefix);
                ofList.endList();
            } else if (jsonString != null) {
                listBuilder.ofSimpleField(DataType.STRING);
            }
        }
        return listBuilder.endList();
    }

    private String retrieveDynamicContentForEntity(String entityId) {
        String jsonString = null;
        String objectKey = null;
        if ("Issue".equals(entityId) && this.connector.getIssueKey() != null) {
            objectKey = this.connector.getIssueKey();
            jsonString = this.getContent(objectKey, UriBuilder.fromUri((String)"/rest/api/2/issue/{issueKey}").build(new Object[]{objectKey}));
        }
        return jsonString;
    }

    private String getContent(String objectKey, URI uri) {
        WebTarget webTarget = this.connector.getStrategy().getJiraClient().getTarget(uri);
        String response = this.connector.getStrategy().getJiraClient().get(webTarget, String.class);
        if (response == null) {
            throw new JiraRestConnectorException(String.format("Metadata for sample object %s could not be retrieved. ", objectKey));
        }
        return response;
    }
}

