/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is published under the terms of the CPAL v1.0 license,
 * a copy of which has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.jirarest.model;

import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Attachment {

    private String self;
    private String filename;
    private JiraUser author;
    private String created;
    private Integer size;
    private String mimeType;
    private String content;
    private String thumbnail;

    @JsonProperty
    public String getSelf() {
        return self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    @JsonProperty
    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @JsonProperty
    public JiraUser getAuthor() {
        return author;
    }

    public void setAuthor(JiraUser author) {
        this.author = author;
    }

    @JsonProperty
    public String getCreated() {
        return created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    @JsonProperty
    public Integer getSize() {
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @JsonProperty
    public String getMimeType() {
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @JsonProperty
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty
    public String getThumbnail() {
        return thumbnail;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AttachmentIssue {
        private AttachmentFields fields;

        @JsonProperty
        public AttachmentFields getFields() {
            return fields;
        }

        public void setFields(AttachmentFields fields) {
            this.fields = fields;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AttachmentFields {
        private List<Attachment> attachment;

        public List<Attachment> getAttachment() {
            return attachment;
        }

        public void setAttachment(List<Attachment> attachment) {
            this.attachment = attachment;
        }
    }
}