
package org.mule.modules.jirarest.connectivity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.module.jira.api.datasense.category.AssigneeCategory;
import org.mule.module.jira.api.datasense.category.CommentCategory;
import org.mule.module.jira.api.datasense.category.CommentsCategory;
import org.mule.module.jira.api.datasense.category.ComponentCategory;
import org.mule.module.jira.api.datasense.category.ComponentPostCategory;
import org.mule.module.jira.api.datasense.category.ComponentsCategory;
import org.mule.module.jira.api.datasense.category.CreateMetaCategory;
import org.mule.module.jira.api.datasense.category.EditMetaCategory;
import org.mule.module.jira.api.datasense.category.GroupCategory;
import org.mule.module.jira.api.datasense.category.IssueCategory;
import org.mule.module.jira.api.datasense.category.IssueLinkCategory;
import org.mule.module.jira.api.datasense.category.IssueLinkGetCategory;
import org.mule.module.jira.api.datasense.category.IssueLinkTypeCategory;
import org.mule.module.jira.api.datasense.category.IssueLinkTypesCategory;
import org.mule.module.jira.api.datasense.category.IssueTypeCategory;
import org.mule.module.jira.api.datasense.category.IssueTypesCategory;
import org.mule.module.jira.api.datasense.category.IssueUpdateCategory;
import org.mule.module.jira.api.datasense.category.NotifyCategory;
import org.mule.module.jira.api.datasense.category.PrioritiesCategory;
import org.mule.module.jira.api.datasense.category.PriorityCategory;
import org.mule.module.jira.api.datasense.category.ProjectCategoriesCategory;
import org.mule.module.jira.api.datasense.category.ProjectCategory;
import org.mule.module.jira.api.datasense.category.ProjectCategoryCategory;
import org.mule.module.jira.api.datasense.category.ProjectStatusesCategory;
import org.mule.module.jira.api.datasense.category.ProjectVersionsCategory;
import org.mule.module.jira.api.datasense.category.ProjectsCategory;
import org.mule.module.jira.api.datasense.category.RemoteLinkCategory;
import org.mule.module.jira.api.datasense.category.RemoteLinksCategory;
import org.mule.module.jira.api.datasense.category.SearchCategory;
import org.mule.module.jira.api.datasense.category.StatusCategory;
import org.mule.module.jira.api.datasense.category.StatusesCategory;
import org.mule.module.jira.api.datasense.category.TransitionCategory;
import org.mule.module.jira.api.datasense.category.TransitionsCategory;
import org.mule.module.jira.api.datasense.category.UserCategory;
import org.mule.module.jira.api.datasense.category.UserGetCategory;
import org.mule.module.jira.api.datasense.category.UsersCategory;
import org.mule.module.jira.api.datasense.category.VersionCategory;
import org.mule.module.jira.api.datasense.category.VotesCategory;
import org.mule.module.jira.api.datasense.category.WatchersCategory;
import org.mule.module.jira.api.datasense.category.WorklogCategory;
import org.mule.module.jira.api.datasense.category.WorklogsCategory;
import org.mule.modules.jirarest.ConnectorConnectionStrategy;
import org.mule.modules.jirarest.JiraRestConnector;
import org.mule.modules.jirarest.adapters.JiraRestConnectorConnectionManagementAdapter;
import org.mule.modules.jirarest.pooling.DevkitGenericKeyedObjectPool;


/**
 * A {@code JiraRestConnectorConfigTypeConnectionManagementConnectionManager} is a wrapper around {@link JiraRestConnector } that adds connection management capabilities to the pojo.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-05-18T03:33:55-07:00", comments = "Build UNNAMED.2405.44720b7")
public class JiraRestConnectorConfigTypeConnectionManagementConnectionManager
    extends ExpressionEvaluatorSupport
    implements MetadataAware, MuleContextAware, ProcessAdapter<JiraRestConnectorConnectionManagementAdapter> , Capabilities, Disposable, Initialisable, Testable, ConnectorMetaDataEnabled, ConnectionManagementConnectionManager<ConnectionManagementConfigTypeJiraRestConnectorConnectionKey, JiraRestConnectorConnectionManagementAdapter, ConnectorConnectionStrategy>
{

    /**
     * 
     */
    private String username;
    /**
     * 
     */
    private String password;
    /**
     * 
     */
    private String serverUrl;
    private String issueKey;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Connector Pool
     * 
     */
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "JiraRest";
    private final static String MODULE_VERSION = "1.0.0";
    private final static String DEVKIT_VERSION = "3.6.1";
    private final static String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private final static String MIN_MULE_VERSION = "3.5.0";

    /**
     * Sets username
     * 
     * @param value Value to set
     */
    public void setUsername(String value) {
        this.username = value;
    }

    /**
     * Retrieves username
     * 
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * Retrieves password
     * 
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Sets serverUrl
     * 
     * @param value Value to set
     */
    public void setServerUrl(String value) {
        this.serverUrl = value;
    }

    /**
     * Retrieves serverUrl
     * 
     */
    public String getServerUrl() {
        return this.serverUrl;
    }

    /**
     * Sets issueKey
     * 
     * @param value Value to set
     */
    public void setIssueKey(String value) {
        this.issueKey = value;
    }

    /**
     * Retrieves issueKey
     * 
     */
    public String getIssueKey() {
        return this.issueKey;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets poolingProfile
     * 
     * @param value Value to set
     */
    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    /**
     * Retrieves poolingProfile
     * 
     */
    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), poolingProfile);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    @Override
    public void dispose() {
        try {
            connectionPool.close();
        } catch (Exception e) {
        }
    }

    public JiraRestConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigTypeJiraRestConnectorConnectionKey key)
        throws Exception
    {
        return ((JiraRestConnectorConnectionManagementAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(ConnectionManagementConfigTypeJiraRestConnectorConnectionKey key, JiraRestConnectorConnectionManagementAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(ConnectionManagementConfigTypeJiraRestConnectorConnectionKey key, JiraRestConnectorConnectionManagementAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, JiraRestConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, muleContext);
    }

    @Override
    public ConnectionManagementConfigTypeJiraRestConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigTypeJiraRestConnectorConnectionKey(getUsername(), getPassword(), getServerUrl());
    }

    @Override
    public ConnectionManagementConfigTypeJiraRestConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event)
        throws Exception
    {
        if (event!= null) {
            final String _transformedUsername = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, getUsername()));
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            final String _transformedPassword = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, getPassword()));
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            final String _transformedServerUrl = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("serverUrl").getGenericType(), null, getServerUrl()));
            if (_transformedServerUrl == null) {
                throw new UnableToAcquireConnectionException("Parameter serverUrl in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigTypeJiraRestConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedServerUrl);
        }
        return getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigTypeJiraRestConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        return getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        ConnectorConnectionStrategyJiraRestConnectorAdapter connection = new ConnectorConnectionStrategyJiraRestConnectorAdapter();
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<ConnectorConnectionStrategy, ConnectionManagementConfigTypeJiraRestConnectorConnectionKey> connection) {
        JiraRestConnectorConnectionManagementAdapter connector = new JiraRestConnectorConnectionManagementAdapter();
        connector.setStrategy(connection.getStrategy());
        connector.setIssueKey(getIssueKey());
        return connector;
    }

    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        JiraRestConnectorConnectionManagementAdapter connector = ((JiraRestConnectorConnectionManagementAdapter) adapter);
        ConnectionManagementConnectionAdapter strategy = ((ConnectionManagementConnectionAdapter) connector.getStrategy());
        return strategy;
    }

    public TestResult test() {
        JiraRestConnectorConnectionManagementAdapter connection = null;
        DefaultTestResult result;
        ConnectionManagementConfigTypeJiraRestConnectorConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            result = ((DefaultTestResult) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
        return result;
    }

    @Override
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        JiraRestConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigTypeJiraRestConnectorConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            try {
                List<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
                AssigneeCategory assigneeCategory = new AssigneeCategory();
                assigneeCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(assigneeCategory.getEntities(), "AssigneeCategory"));
                ComponentsCategory componentsCategory = new ComponentsCategory();
                componentsCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(componentsCategory.getEntities(), "ComponentsCategory"));
                IssueLinkTypeCategory issueLinkTypeCategory = new IssueLinkTypeCategory();
                issueLinkTypeCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueLinkTypeCategory.getEntities(), "IssueLinkTypeCategory"));
                PriorityCategory priorityCategory = new PriorityCategory();
                priorityCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(priorityCategory.getEntities(), "PriorityCategory"));
                ProjectStatusesCategory projectStatusesCategory = new ProjectStatusesCategory();
                projectStatusesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(projectStatusesCategory.getEntities(), "ProjectStatusesCategory"));
                IssueLinkGetCategory issueLinkGetCategory = new IssueLinkGetCategory();
                issueLinkGetCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueLinkGetCategory.getEntities(), "IssueLinkGetCategory"));
                TransitionsCategory transitionsCategory = new TransitionsCategory();
                transitionsCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(transitionsCategory.getEntities(), "TransitionsCategory"));
                ComponentCategory componentCategory = new ComponentCategory();
                componentCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(componentCategory.getEntities(), "ComponentCategory"));
                IssueLinkTypesCategory issueLinkTypesCategory = new IssueLinkTypesCategory();
                issueLinkTypesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueLinkTypesCategory.getEntities(), "IssueLinkTypesCategory"));
                PrioritiesCategory prioritiesCategory = new PrioritiesCategory();
                prioritiesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(prioritiesCategory.getEntities(), "PrioritiesCategory"));
                ProjectCategory projectCategory = new ProjectCategory();
                projectCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(projectCategory.getEntities(), "ProjectCategory"));
                StatusesCategory statusesCategory = new StatusesCategory();
                statusesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(statusesCategory.getEntities(), "StatusesCategory"));
                StatusCategory statusCategory = new StatusCategory();
                statusCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(statusCategory.getEntities(), "StatusCategory"));
                RemoteLinkCategory remoteLinkCategory = new RemoteLinkCategory();
                remoteLinkCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(remoteLinkCategory.getEntities(), "RemoteLinkCategory"));
                ProjectCategoriesCategory projectCategoriesCategory = new ProjectCategoriesCategory();
                projectCategoriesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(projectCategoriesCategory.getEntities(), "ProjectCategoriesCategory"));
                IssueLinkCategory issueLinkCategory = new IssueLinkCategory();
                issueLinkCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueLinkCategory.getEntities(), "IssueLinkCategory"));
                VersionCategory versionCategory = new VersionCategory();
                versionCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(versionCategory.getEntities(), "VersionCategory"));
                UserCategory userCategory = new UserCategory();
                userCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(userCategory.getEntities(), "UserCategory"));
                ProjectCategoryCategory projectCategoryCategory = new ProjectCategoryCategory();
                projectCategoryCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(projectCategoryCategory.getEntities(), "ProjectCategoryCategory"));
                CreateMetaCategory createMetaCategory = new CreateMetaCategory();
                createMetaCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(createMetaCategory.getEntities(), "CreateMetaCategory"));
                IssueTypesCategory issueTypesCategory = new IssueTypesCategory();
                issueTypesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueTypesCategory.getEntities(), "IssueTypesCategory"));
                WorklogCategory worklogCategory = new WorklogCategory();
                worklogCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(worklogCategory.getEntities(), "WorklogCategory"));
                NotifyCategory notifyCategory = new NotifyCategory();
                notifyCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(notifyCategory.getEntities(), "NotifyCategory"));
                VotesCategory votesCategory = new VotesCategory();
                votesCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(votesCategory.getEntities(), "VotesCategory"));
                WorklogsCategory worklogsCategory = new WorklogsCategory();
                worklogsCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(worklogsCategory.getEntities(), "WorklogsCategory"));
                UserGetCategory userGetCategory = new UserGetCategory();
                userGetCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(userGetCategory.getEntities(), "UserGetCategory"));
                IssueTypeCategory issueTypeCategory = new IssueTypeCategory();
                issueTypeCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueTypeCategory.getEntities(), "IssueTypeCategory"));
                IssueCategory issueCategory = new IssueCategory();
                issueCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueCategory.getEntities(), "IssueCategory"));
                RemoteLinksCategory remoteLinksCategory = new RemoteLinksCategory();
                remoteLinksCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(remoteLinksCategory.getEntities(), "RemoteLinksCategory"));
                WatchersCategory watchersCategory = new WatchersCategory();
                watchersCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(watchersCategory.getEntities(), "WatchersCategory"));
                GroupCategory groupCategory = new GroupCategory();
                groupCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(groupCategory.getEntities(), "GroupCategory"));
                ComponentPostCategory componentPostCategory = new ComponentPostCategory();
                componentPostCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(componentPostCategory.getEntities(), "ComponentPostCategory"));
                SearchCategory searchCategory = new SearchCategory();
                searchCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(searchCategory.getEntities(), "SearchCategory"));
                CommentCategory commentCategory = new CommentCategory();
                commentCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(commentCategory.getEntities(), "CommentCategory"));
                CommentsCategory commentsCategory = new CommentsCategory();
                commentsCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(commentsCategory.getEntities(), "CommentsCategory"));
                UsersCategory usersCategory = new UsersCategory();
                usersCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(usersCategory.getEntities(), "UsersCategory"));
                EditMetaCategory editMetaCategory = new EditMetaCategory();
                editMetaCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(editMetaCategory.getEntities(), "EditMetaCategory"));
                TransitionCategory transitionCategory = new TransitionCategory();
                transitionCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(transitionCategory.getEntities(), "TransitionCategory"));
                ProjectsCategory projectsCategory = new ProjectsCategory();
                projectsCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(projectsCategory.getEntities(), "ProjectsCategory"));
                IssueUpdateCategory issueUpdateCategory = new IssueUpdateCategory();
                issueUpdateCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(issueUpdateCategory.getEntities(), "IssueUpdateCategory"));
                ProjectVersionsCategory projectVersionsCategory = new ProjectVersionsCategory();
                projectVersionsCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(fillCategory(projectVersionsCategory.getEntities(), "ProjectVersionsCategory"));
                return new DefaultResult<List<MetaDataKey>>(gatheredMetaDataKeys, (Result.Status.SUCCESS));
            } catch (Exception e) {
                return new DefaultResult<List<MetaDataKey>>(null, (Result.Status.FAILURE), "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, e);
            }
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            return ((DefaultResult<List<MetaDataKey>> ) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
    }

    private List<MetaDataKey> fillCategory(List<MetaDataKey> metadataKeys, String categoryClassName) {
        for (MetaDataKey metaDataKey: metadataKeys) {
            ((DefaultMetaDataKey) metaDataKey).setCategory(categoryClassName);
        }
        return metadataKeys;
    }

    @Override
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        JiraRestConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigTypeJiraRestConnectorConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            try {
                MetaData metaData = null;
                TypeDescribingProperty property = metaDataKey.getProperty(TypeDescribingProperty.class);
                String category = ((DefaultMetaDataKey) metaDataKey).getCategory();
                if (category!= null) {
                    if (category.equals("AssigneeCategory")) {
                        AssigneeCategory assigneeCategory = new AssigneeCategory();
                        assigneeCategory.setMyconnector(connection);
                        metaData = assigneeCategory.describeEntity(metaDataKey);
                    } else {
                        if (category.equals("ComponentsCategory")) {
                            ComponentsCategory componentsCategory = new ComponentsCategory();
                            componentsCategory.setMyconnector(connection);
                            metaData = componentsCategory.describeEntity(metaDataKey);
                        } else {
                            if (category.equals("IssueLinkTypeCategory")) {
                                IssueLinkTypeCategory issueLinkTypeCategory = new IssueLinkTypeCategory();
                                issueLinkTypeCategory.setMyconnector(connection);
                                metaData = issueLinkTypeCategory.describeEntity(metaDataKey);
                            } else {
                                if (category.equals("PriorityCategory")) {
                                    PriorityCategory priorityCategory = new PriorityCategory();
                                    priorityCategory.setMyconnector(connection);
                                    metaData = priorityCategory.describeEntity(metaDataKey);
                                } else {
                                    if (category.equals("ProjectStatusesCategory")) {
                                        ProjectStatusesCategory projectStatusesCategory = new ProjectStatusesCategory();
                                        projectStatusesCategory.setMyconnector(connection);
                                        metaData = projectStatusesCategory.describeEntity(metaDataKey);
                                    } else {
                                        if (category.equals("IssueLinkGetCategory")) {
                                            IssueLinkGetCategory issueLinkGetCategory = new IssueLinkGetCategory();
                                            issueLinkGetCategory.setMyconnector(connection);
                                            metaData = issueLinkGetCategory.describeEntity(metaDataKey);
                                        } else {
                                            if (category.equals("TransitionsCategory")) {
                                                TransitionsCategory transitionsCategory = new TransitionsCategory();
                                                transitionsCategory.setMyconnector(connection);
                                                metaData = transitionsCategory.describeEntity(metaDataKey);
                                            } else {
                                                if (category.equals("ComponentCategory")) {
                                                    ComponentCategory componentCategory = new ComponentCategory();
                                                    componentCategory.setMyconnector(connection);
                                                    metaData = componentCategory.describeEntity(metaDataKey);
                                                } else {
                                                    if (category.equals("IssueLinkTypesCategory")) {
                                                        IssueLinkTypesCategory issueLinkTypesCategory = new IssueLinkTypesCategory();
                                                        issueLinkTypesCategory.setMyconnector(connection);
                                                        metaData = issueLinkTypesCategory.describeEntity(metaDataKey);
                                                    } else {
                                                        if (category.equals("PrioritiesCategory")) {
                                                            PrioritiesCategory prioritiesCategory = new PrioritiesCategory();
                                                            prioritiesCategory.setMyconnector(connection);
                                                            metaData = prioritiesCategory.describeEntity(metaDataKey);
                                                        } else {
                                                            if (category.equals("ProjectCategory")) {
                                                                ProjectCategory projectCategory = new ProjectCategory();
                                                                projectCategory.setMyconnector(connection);
                                                                metaData = projectCategory.describeEntity(metaDataKey);
                                                            } else {
                                                                if (category.equals("StatusesCategory")) {
                                                                    StatusesCategory statusesCategory = new StatusesCategory();
                                                                    statusesCategory.setMyconnector(connection);
                                                                    metaData = statusesCategory.describeEntity(metaDataKey);
                                                                } else {
                                                                    if (category.equals("StatusCategory")) {
                                                                        StatusCategory statusCategory = new StatusCategory();
                                                                        statusCategory.setMyconnector(connection);
                                                                        metaData = statusCategory.describeEntity(metaDataKey);
                                                                    } else {
                                                                        if (category.equals("RemoteLinkCategory")) {
                                                                            RemoteLinkCategory remoteLinkCategory = new RemoteLinkCategory();
                                                                            remoteLinkCategory.setMyconnector(connection);
                                                                            metaData = remoteLinkCategory.describeEntity(metaDataKey);
                                                                        } else {
                                                                            if (category.equals("ProjectCategoriesCategory")) {
                                                                                ProjectCategoriesCategory projectCategoriesCategory = new ProjectCategoriesCategory();
                                                                                projectCategoriesCategory.setMyconnector(connection);
                                                                                metaData = projectCategoriesCategory.describeEntity(metaDataKey);
                                                                            } else {
                                                                                if (category.equals("IssueLinkCategory")) {
                                                                                    IssueLinkCategory issueLinkCategory = new IssueLinkCategory();
                                                                                    issueLinkCategory.setMyconnector(connection);
                                                                                    metaData = issueLinkCategory.describeEntity(metaDataKey);
                                                                                } else {
                                                                                    if (category.equals("VersionCategory")) {
                                                                                        VersionCategory versionCategory = new VersionCategory();
                                                                                        versionCategory.setMyconnector(connection);
                                                                                        metaData = versionCategory.describeEntity(metaDataKey);
                                                                                    } else {
                                                                                        if (category.equals("UserCategory")) {
                                                                                            UserCategory userCategory = new UserCategory();
                                                                                            userCategory.setMyconnector(connection);
                                                                                            metaData = userCategory.describeEntity(metaDataKey);
                                                                                        } else {
                                                                                            if (category.equals("ProjectCategoryCategory")) {
                                                                                                ProjectCategoryCategory projectCategoryCategory = new ProjectCategoryCategory();
                                                                                                projectCategoryCategory.setMyconnector(connection);
                                                                                                metaData = projectCategoryCategory.describeEntity(metaDataKey);
                                                                                            } else {
                                                                                                if (category.equals("CreateMetaCategory")) {
                                                                                                    CreateMetaCategory createMetaCategory = new CreateMetaCategory();
                                                                                                    createMetaCategory.setMyconnector(connection);
                                                                                                    metaData = createMetaCategory.describeEntity(metaDataKey);
                                                                                                } else {
                                                                                                    if (category.equals("IssueTypesCategory")) {
                                                                                                        IssueTypesCategory issueTypesCategory = new IssueTypesCategory();
                                                                                                        issueTypesCategory.setMyconnector(connection);
                                                                                                        metaData = issueTypesCategory.describeEntity(metaDataKey);
                                                                                                    } else {
                                                                                                        if (category.equals("WorklogCategory")) {
                                                                                                            WorklogCategory worklogCategory = new WorklogCategory();
                                                                                                            worklogCategory.setMyconnector(connection);
                                                                                                            metaData = worklogCategory.describeEntity(metaDataKey);
                                                                                                        } else {
                                                                                                            if (category.equals("NotifyCategory")) {
                                                                                                                NotifyCategory notifyCategory = new NotifyCategory();
                                                                                                                notifyCategory.setMyconnector(connection);
                                                                                                                metaData = notifyCategory.describeEntity(metaDataKey);
                                                                                                            } else {
                                                                                                                if (category.equals("VotesCategory")) {
                                                                                                                    VotesCategory votesCategory = new VotesCategory();
                                                                                                                    votesCategory.setMyconnector(connection);
                                                                                                                    metaData = votesCategory.describeEntity(metaDataKey);
                                                                                                                } else {
                                                                                                                    if (category.equals("WorklogsCategory")) {
                                                                                                                        WorklogsCategory worklogsCategory = new WorklogsCategory();
                                                                                                                        worklogsCategory.setMyconnector(connection);
                                                                                                                        metaData = worklogsCategory.describeEntity(metaDataKey);
                                                                                                                    } else {
                                                                                                                        if (category.equals("UserGetCategory")) {
                                                                                                                            UserGetCategory userGetCategory = new UserGetCategory();
                                                                                                                            userGetCategory.setMyconnector(connection);
                                                                                                                            metaData = userGetCategory.describeEntity(metaDataKey);
                                                                                                                        } else {
                                                                                                                            if (category.equals("IssueTypeCategory")) {
                                                                                                                                IssueTypeCategory issueTypeCategory = new IssueTypeCategory();
                                                                                                                                issueTypeCategory.setMyconnector(connection);
                                                                                                                                metaData = issueTypeCategory.describeEntity(metaDataKey);
                                                                                                                            } else {
                                                                                                                                if (category.equals("IssueCategory")) {
                                                                                                                                    IssueCategory issueCategory = new IssueCategory();
                                                                                                                                    issueCategory.setMyconnector(connection);
                                                                                                                                    metaData = issueCategory.describeEntity(metaDataKey);
                                                                                                                                } else {
                                                                                                                                    if (category.equals("RemoteLinksCategory")) {
                                                                                                                                        RemoteLinksCategory remoteLinksCategory = new RemoteLinksCategory();
                                                                                                                                        remoteLinksCategory.setMyconnector(connection);
                                                                                                                                        metaData = remoteLinksCategory.describeEntity(metaDataKey);
                                                                                                                                    } else {
                                                                                                                                        if (category.equals("WatchersCategory")) {
                                                                                                                                            WatchersCategory watchersCategory = new WatchersCategory();
                                                                                                                                            watchersCategory.setMyconnector(connection);
                                                                                                                                            metaData = watchersCategory.describeEntity(metaDataKey);
                                                                                                                                        } else {
                                                                                                                                            if (category.equals("GroupCategory")) {
                                                                                                                                                GroupCategory groupCategory = new GroupCategory();
                                                                                                                                                groupCategory.setMyconnector(connection);
                                                                                                                                                metaData = groupCategory.describeEntity(metaDataKey);
                                                                                                                                            } else {
                                                                                                                                                if (category.equals("ComponentPostCategory")) {
                                                                                                                                                    ComponentPostCategory componentPostCategory = new ComponentPostCategory();
                                                                                                                                                    componentPostCategory.setMyconnector(connection);
                                                                                                                                                    metaData = componentPostCategory.describeEntity(metaDataKey);
                                                                                                                                                } else {
                                                                                                                                                    if (category.equals("SearchCategory")) {
                                                                                                                                                        SearchCategory searchCategory = new SearchCategory();
                                                                                                                                                        searchCategory.setMyconnector(connection);
                                                                                                                                                        metaData = searchCategory.describeEntity(metaDataKey);
                                                                                                                                                    } else {
                                                                                                                                                        if (category.equals("CommentCategory")) {
                                                                                                                                                            CommentCategory commentCategory = new CommentCategory();
                                                                                                                                                            commentCategory.setMyconnector(connection);
                                                                                                                                                            metaData = commentCategory.describeEntity(metaDataKey);
                                                                                                                                                        } else {
                                                                                                                                                            if (category.equals("CommentsCategory")) {
                                                                                                                                                                CommentsCategory commentsCategory = new CommentsCategory();
                                                                                                                                                                commentsCategory.setMyconnector(connection);
                                                                                                                                                                metaData = commentsCategory.describeEntity(metaDataKey);
                                                                                                                                                            } else {
                                                                                                                                                                if (category.equals("UsersCategory")) {
                                                                                                                                                                    UsersCategory usersCategory = new UsersCategory();
                                                                                                                                                                    usersCategory.setMyconnector(connection);
                                                                                                                                                                    metaData = usersCategory.describeEntity(metaDataKey);
                                                                                                                                                                } else {
                                                                                                                                                                    if (category.equals("EditMetaCategory")) {
                                                                                                                                                                        EditMetaCategory editMetaCategory = new EditMetaCategory();
                                                                                                                                                                        editMetaCategory.setMyconnector(connection);
                                                                                                                                                                        metaData = editMetaCategory.describeEntity(metaDataKey);
                                                                                                                                                                    } else {
                                                                                                                                                                        if (category.equals("TransitionCategory")) {
                                                                                                                                                                            TransitionCategory transitionCategory = new TransitionCategory();
                                                                                                                                                                            transitionCategory.setMyconnector(connection);
                                                                                                                                                                            metaData = transitionCategory.describeEntity(metaDataKey);
                                                                                                                                                                        } else {
                                                                                                                                                                            if (category.equals("ProjectsCategory")) {
                                                                                                                                                                                ProjectsCategory projectsCategory = new ProjectsCategory();
                                                                                                                                                                                projectsCategory.setMyconnector(connection);
                                                                                                                                                                                metaData = projectsCategory.describeEntity(metaDataKey);
                                                                                                                                                                            } else {
                                                                                                                                                                                if (category.equals("IssueUpdateCategory")) {
                                                                                                                                                                                    IssueUpdateCategory issueUpdateCategory = new IssueUpdateCategory();
                                                                                                                                                                                    issueUpdateCategory.setMyconnector(connection);
                                                                                                                                                                                    metaData = issueUpdateCategory.describeEntity(metaDataKey);
                                                                                                                                                                                } else {
                                                                                                                                                                                    if (category.equals("ProjectVersionsCategory")) {
                                                                                                                                                                                        ProjectVersionsCategory projectVersionsCategory = new ProjectVersionsCategory();
                                                                                                                                                                                        projectVersionsCategory.setMyconnector(connection);
                                                                                                                                                                                        metaData = projectVersionsCategory.describeEntity(metaDataKey);
                                                                                                                                                                                    } else {
                                                                                                                                                                                        throw new Exception(((("Invalid key type. There is no matching category for ["+ metaDataKey.getId())+"]. All keys must contain a category with any of the following options:[AssigneeCategory, ComponentsCategory, IssueLinkTypeCategory, PriorityCategory, ProjectStatusesCategory, IssueLinkGetCategory, TransitionsCategory, ComponentCategory, IssueLinkTypesCategory, PrioritiesCategory, ProjectCategory, StatusesCategory, StatusCategory, RemoteLinkCategory, ProjectCategoriesCategory, IssueLinkCategory, VersionCategory, UserCategory, ProjectCategoryCategory, CreateMetaCategory, IssueTypesCategory, WorklogCategory, NotifyCategory, VotesCategory, WorklogsCategory, UserGetCategory, IssueTypeCategory, IssueCategory, RemoteLinksCategory, WatchersCategory, GroupCategory, ComponentPostCategory, SearchCategory, CommentCategory, CommentsCategory, UsersCategory, EditMetaCategory, TransitionCategory, ProjectsCategory, IssueUpdateCategory, ProjectVersionsCategory]")+((", but found ["+ category)+"] instead")));
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    throw new Exception((("Invalid key type. There is no matching category for ["+ metaDataKey.getId())+"]. All keys must contain a category with any of the following options:[AssigneeCategory, ComponentsCategory, IssueLinkTypeCategory, PriorityCategory, ProjectStatusesCategory, IssueLinkGetCategory, TransitionsCategory, ComponentCategory, IssueLinkTypesCategory, PrioritiesCategory, ProjectCategory, StatusesCategory, StatusCategory, RemoteLinkCategory, ProjectCategoriesCategory, IssueLinkCategory, VersionCategory, UserCategory, ProjectCategoryCategory, CreateMetaCategory, IssueTypesCategory, WorklogCategory, NotifyCategory, VotesCategory, WorklogsCategory, UserGetCategory, IssueTypeCategory, IssueCategory, RemoteLinksCategory, WatchersCategory, GroupCategory, ComponentPostCategory, SearchCategory, CommentCategory, CommentsCategory, UsersCategory, EditMetaCategory, TransitionCategory, ProjectsCategory, IssueUpdateCategory, ProjectVersionsCategory]"));
                }
                metaData.getPayload().addProperty(new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
                return new DefaultResult<MetaData>(metaData);
            } catch (Exception e) {
                return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), getMetaDataException(metaDataKey), MetaDataFailureType.ERROR_METADATA_RETRIEVER, e);
            }
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            return ((DefaultResult<MetaData> ) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if ((key!= null)&&(key.getId()!= null)) {
            return ("There was an error retrieving metadata from key: "+(key.getId()+" after acquiring the connection, for more detailed information please read the provided stacktrace"));
        } else {
            return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
        }
    }

}
