/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is published under the terms of the CPAL v1.0 license,
 * a copy of which has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.jirarest.client;

import java.net.URI;
import java.util.List;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;

import org.mule.modules.jirarest.model.Attachment;
import org.mule.modules.jirarest.model.Attachment.AttachmentIssue;

public class RestIssueClient {

    private JiraClient client;

    public RestIssueClient(JiraClient client) {
        this.client = client;
    }

    public List<Attachment> getAttachments(String issueIdOrKey) {
        final URI uri = UriBuilder.fromUri("/rest/api/2/issue/{issueIdOrKey}".replace("{issueIdOrKey}", issueIdOrKey))
                .queryParam("fields", "attachment")
                .build();
        WebTarget target = client.getTarget(uri);
        AttachmentIssue issue = client.get(target, AttachmentIssue.class);
        return issue.getFields().getAttachment();
    }
}