/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is published under the terms of the CPAL v1.0 license,
 * a copy of which has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.jirarest.client;

import java.io.IOException;
import java.io.InputStream;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class RedirectFilter implements ClientResponseFilter {

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException
    {
        if (responseContext.getStatusInfo().getStatusCode() == 201 && responseContext.getLocation() != null) {
            Response resp = requestContext.getClient().target(responseContext.getLocation()).request().get();
            InputStream entity = (InputStream) resp.getEntity();
            responseContext.getHeaders().clear();
            responseContext.getHeaders().putAll(resp.getStringHeaders());
            responseContext.setEntityStream(entity);
            responseContext.setStatusInfo(resp.getStatusInfo());
            responseContext.setStatus(resp.getStatus());
        }
    }
}
