/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is published under the terms of the CPAL v1.0 license,
 * a copy of which has been included with this distribution in the LICENSE.md file.
 */

package org.mule.module.jira.api.datasense.category;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.codehaus.jettison.json.JSONException;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.jira.api.datasense.JiraMetaDataBuilder;
import org.mule.modules.jirarest.JiraRestConnector;

public class BaseCategory {

    @Inject
    private JiraRestConnector myconnector;

    public JiraRestConnector getMyconnector() {
        return myconnector;
    }

    public void setMyconnector(JiraRestConnector myconnector) {
        this.myconnector = myconnector;
    }

    public List<MetaDataKey> getEntities(String key, String label) {
        List<MetaDataKey> entities = new ArrayList<MetaDataKey>();
        entities.add(new DefaultMetaDataKey(key, label));
        return entities;
    }

    @MetaDataRetriever
    public MetaData describeEntity(MetaDataKey entityKey) throws IOException, JSONException {
        final String key = entityKey.getId();
        final JiraMetaDataBuilder jiraMetaDataBuilder = new JiraMetaDataBuilder(myconnector);
        return new DefaultMetaData(jiraMetaDataBuilder.build(key));
    }
}
