/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.strategy;

import com.google.api.ads.common.lib.auth.OfflineCredentials;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.ads.dfp.lib.client.DfpSession;
import com.google.api.client.auth.oauth2.Credential;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;

public class GoogleDfpConnectionStrategy {
    private DfpSession session;
    private String refreshToken;
    private String tokenServerUrl;
    private String applicationName;
    private String endpoint;
    private String networkCode;

    public void connect(String clientId, String clientSecret) throws ConnectionException {
        try {
            Credential oAuth2Credential = new OfflineCredentials.Builder().forApi(OfflineCredentials.Api.DFP).withClientSecrets(clientId, clientSecret).withRefreshToken(this.refreshToken).withTokenUrlServer(this.tokenServerUrl).build().generateCredential();
            this.session = new DfpSession.Builder().withApplicationName(this.applicationName).withEndpoint(this.endpoint).withOAuth2Credential(oAuth2Credential).withNetworkCode(this.networkCode).build();
        }
        catch (OAuthException e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "001", e.getMessage(), (Throwable)e);
        }
        catch (ValidationException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "002", e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect() {
        this.session = null;
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public String connectionId() {
        return "001";
    }

    public DfpSession getSession() {
        return this.session;
    }

    public void setSession(DfpSession session) {
        this.session = session;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public void setTokenServerUrl(String tokenServerUrl) {
        this.tokenServerUrl = tokenServerUrl;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }
}

