/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.services;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.dfp.axis.factory.DfpServices;
import com.google.api.ads.dfp.axis.utils.v201411.StatementBuilder;
import com.google.api.ads.dfp.axis.v201411.ApiException;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReport;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReportPage;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReportServiceInterface;
import com.google.api.ads.dfp.lib.client.DfpSession;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.mule.modules.google.dfp.exceptions.ReconciliationReportByIdException;

public class ReconciliationReportService {
    private static final Logger logger = Logger.getLogger(ReconciliationReportService.class);

    protected ReconciliationReportServiceInterface createReconciliationReportService(DfpSession session) {
        DfpServices dfpServices = new DfpServices();
        ReconciliationReportServiceInterface reconciliationReportService = (ReconciliationReportServiceInterface)dfpServices.get((AdsSession)session, ReconciliationReportServiceInterface.class);
        return reconciliationReportService;
    }

    public List<Long> getReconciliationReportIdsByStartDate(DfpSession session, String startDate) throws ReconciliationReportByIdException {
        try {
            ReconciliationReportServiceInterface reconciliationReportService = this.createReconciliationReportService(session);
            StatementBuilder statementBuilder = new StatementBuilder().where("startDate = :startDate").withBindVariableValue("startDate", (Object)startDate).limit(Integer.valueOf(500));
            int totalResultSetSize = 0;
            ArrayList<Long> reconciliationReportIds = new ArrayList<Long>();
            do {
                ReconciliationReportPage page;
                if ((page = reconciliationReportService.getReconciliationReportsByStatement(statementBuilder.toStatement())).getResults() != null) {
                    totalResultSetSize = page.getTotalResultSetSize();
                    for (ReconciliationReport reconciliationReport : page.getResults()) {
                        reconciliationReportIds.add(reconciliationReport.getId());
                    }
                }
                statementBuilder.increaseOffsetBy(Integer.valueOf(500));
            } while (statementBuilder.getOffset() < totalResultSetSize);
            logger.info((Object)("Number of results found: " + totalResultSetSize + "."));
            return reconciliationReportIds;
        }
        catch (NullPointerException e) {
            throw new ReconciliationReportByIdException(e);
        }
        catch (ApiException e) {
            throw new ReconciliationReportByIdException(e);
        }
        catch (RemoteException e) {
            throw new ReconciliationReportByIdException(e);
        }
    }
}

