/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.services;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.dfp.axis.factory.DfpServices;
import com.google.api.ads.dfp.axis.utils.v201411.StatementBuilder;
import com.google.api.ads.dfp.axis.v201411.ApiException;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReportRow;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReportRowPage;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReportRowServiceInterface;
import com.google.api.ads.dfp.lib.client.DfpSession;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.mule.modules.google.dfp.exceptions.ReconciliationReportRowException;
import org.mule.modules.google.dfp.reconciliationreport.ReconciliationQueryParams;

public class ReconciliationReportRowService {
    private static final Logger logger = Logger.getLogger(ReconciliationReportRowService.class);

    protected ReconciliationReportRowServiceInterface createReconciliationReportRowService(DfpSession session) {
        DfpServices dfpServices = new DfpServices();
        ReconciliationReportRowServiceInterface reconciliationReportService = (ReconciliationReportRowServiceInterface)dfpServices.get((AdsSession)session, ReconciliationReportRowServiceInterface.class);
        return reconciliationReportService;
    }

    public List<ReconciliationReportRow> getReconciliationReportRows(DfpSession session, ReconciliationQueryParams queryParams) throws ReconciliationReportRowException {
        try {
            ReconciliationReportRowServiceInterface reconciliationReportRowService = this.createReconciliationReportRowService(session);
            StatementBuilder statementBuilder = new StatementBuilder().where("orderId = :orderId AND lineItemid = :lineItemId AND reconciliationReportId = :reconciliationReportId").withBindVariableValue("orderId", (Object)queryParams.getOrderId()).withBindVariableValue("lineItemId", (Object)queryParams.getLineItemId()).withBindVariableValue("reconciliationReportId", (Object)queryParams.getReconciliationReportId());
            int totalResultSetSize = 0;
            ArrayList<ReconciliationReportRow> reconciliationRows = new ArrayList<ReconciliationReportRow>();
            do {
                ReconciliationReportRowPage page;
                if ((page = reconciliationReportRowService.getReconciliationReportRowsByStatement(statementBuilder.toStatement())).getResults() != null) {
                    totalResultSetSize = page.getTotalResultSetSize();
                    for (ReconciliationReportRow reconciliationReportRow : page.getResults()) {
                        reconciliationRows.add(reconciliationReportRow);
                        logger.info((Object)("Order ID: " + reconciliationReportRow.getOrderId() + ", Line item ID: " + reconciliationReportRow.getLineItemId() + ", and Reconciliation Report ID" + reconciliationReportRow.getReconciliationReportId() + " was found. The following comment was found for this record: " + reconciliationReportRow.getComments() + "."));
                    }
                }
                statementBuilder.increaseOffsetBy(Integer.valueOf(500));
            } while (statementBuilder.getOffset() < totalResultSetSize);
            return reconciliationRows;
        }
        catch (ApiException e) {
            throw new ReconciliationReportRowException(e);
        }
        catch (RemoteException e) {
            throw new ReconciliationReportRowException(e);
        }
        catch (Exception e) {
            throw new ReconciliationReportRowException(e);
        }
    }
}

