/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.services;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.dfp.axis.factory.DfpServices;
import com.google.api.ads.dfp.axis.utils.v201411.StatementBuilder;
import com.google.api.ads.dfp.axis.v201411.ApiException;
import com.google.api.ads.dfp.axis.v201411.Company;
import com.google.api.ads.dfp.axis.v201411.CompanyPage;
import com.google.api.ads.dfp.axis.v201411.CompanyServiceInterface;
import com.google.api.ads.dfp.axis.v201411.CompanyType;
import com.google.api.ads.dfp.lib.client.DfpSession;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.mule.modules.google.dfp.exceptions.CreateFailedException;
import org.mule.modules.google.dfp.exceptions.GetAdvertiserByNameException;
import org.mule.modules.google.dfp.exceptions.GetAgencyByNameException;
import org.mule.modules.google.dfp.exceptions.GetAllCompaniesException;
import org.mule.modules.google.dfp.exceptions.GetCompanyByIdException;
import org.mule.modules.google.dfp.exceptions.GetCompanyCommentByNameException;
import org.mule.modules.google.dfp.exceptions.TooManyAdvertisersFoundException;
import org.mule.modules.google.dfp.exceptions.TooManyAgenciesFoundException;
import org.mule.modules.google.dfp.exceptions.TooManyCompaniesFoundException;
import org.mule.modules.google.dfp.exceptions.UpdateFailedException;

public class CompanyService {
    private static final Logger logger = Logger.getLogger(CompanyService.class);

    protected CompanyServiceInterface createCompanyService(DfpSession session) {
        DfpServices dfpServices = new DfpServices();
        CompanyServiceInterface companyService = (CompanyServiceInterface)dfpServices.get((AdsSession)session, CompanyServiceInterface.class);
        return companyService;
    }

    public List<Company> getAllCompanies(DfpSession session) throws GetAllCompaniesException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            StatementBuilder statementBuilder = new StatementBuilder();
            CompanyPage page = companyService.getCompaniesByStatement(statementBuilder.toStatement());
            Company[] companies = page.getResults();
            return Arrays.asList(companies);
        }
        catch (ApiException e) {
            throw new GetAllCompaniesException(e);
        }
        catch (RemoteException e) {
            throw new GetAllCompaniesException(e);
        }
        catch (Exception e) {
            throw new GetAllCompaniesException(e);
        }
    }

    public String getCompanyCommentByName(DfpSession session, String name) throws GetCompanyCommentByNameException, TooManyCompaniesFoundException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            StatementBuilder statementBuilder = new StatementBuilder().where("name = :name").withBindVariableValue("name", (Object)name);
            CompanyPage page = companyService.getCompaniesByStatement(statementBuilder.toStatement());
            if (page.getResults() == null || page.getTotalResultSetSize() != 1) {
                throw new TooManyCompaniesFoundException(page.getTotalResultSetSize());
            }
            Company company = page.getResults(0);
            logger.info((Object)("Company with ID " + company.getId() + " , name " + company.getName() + " type " + company.getType() + " and comment " + company.getComment() + " was found."));
            return company.getComment();
        }
        catch (ApiException e) {
            throw new GetCompanyCommentByNameException(e);
        }
        catch (RemoteException e) {
            throw new GetCompanyCommentByNameException(e);
        }
        catch (Exception e) {
            throw new GetCompanyCommentByNameException(e);
        }
    }

    public String getAdvertiserByName(DfpSession session, String name) throws GetAdvertiserByNameException, TooManyAdvertisersFoundException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            StatementBuilder statementBuilder = new StatementBuilder().where("type = :type AND name = :name").orderBy("id ASC").limit(Integer.valueOf(500)).withBindVariableValue("type", (Object)CompanyType.ADVERTISER.toString()).withBindVariableValue("name", (Object)name);
            int totalResultSetSize = 0;
            String externalId = "";
            do {
                CompanyPage page;
                if ((page = companyService.getCompaniesByStatement(statementBuilder.toStatement())).getResults() != null) {
                    totalResultSetSize = page.getTotalResultSetSize();
                    if (totalResultSetSize > 1) {
                        logger.info((Object)("Duplicate Advertisers with the name: " + name));
                        throw new TooManyAdvertisersFoundException(totalResultSetSize);
                    }
                    for (Company company : page.getResults()) {
                        externalId = company.getExternalId();
                    }
                } else {
                    logger.info((Object)("No Advertisers with the name: " + name + " were found."));
                }
                statementBuilder.increaseOffsetBy(Integer.valueOf(500));
            } while (statementBuilder.getOffset() < totalResultSetSize);
            logger.info((Object)("Number of Advertisers found:" + totalResultSetSize));
            return externalId;
        }
        catch (ApiException e) {
            throw new GetAdvertiserByNameException(e);
        }
        catch (RemoteException e) {
            throw new GetAdvertiserByNameException(e);
        }
        catch (Exception e) {
            throw new GetAdvertiserByNameException(e);
        }
    }

    public Company getAgencyByName(DfpSession session, String name) throws GetAgencyByNameException, TooManyAgenciesFoundException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            StatementBuilder statementBuilder = new StatementBuilder().where("type = :type AND name = :name").orderBy("id ASC").limit(Integer.valueOf(500)).withBindVariableValue("type", (Object)CompanyType.AGENCY.toString()).withBindVariableValue("name", (Object)name);
            int totalResultSetSize = 0;
            Company companyFound = null;
            do {
                CompanyPage page;
                if ((page = companyService.getCompaniesByStatement(statementBuilder.toStatement())).getResults() != null) {
                    totalResultSetSize = page.getTotalResultSetSize();
                    if (totalResultSetSize > 1) {
                        logger.info((Object)("Duplicate Agencies with the name: " + name));
                        throw new TooManyAgenciesFoundException(totalResultSetSize);
                    }
                    companyFound = page.getResults(0);
                } else {
                    logger.info((Object)("No Agency with the name: " + name + " were found."));
                }
                statementBuilder.increaseOffsetBy(Integer.valueOf(500));
            } while (statementBuilder.getOffset() < totalResultSetSize);
            logger.info((Object)("Number of Agencies found:" + totalResultSetSize));
            return companyFound;
        }
        catch (ApiException e) {
            throw new GetAgencyByNameException(e);
        }
        catch (RemoteException e) {
            throw new GetAgencyByNameException(e);
        }
        catch (Exception e) {
            throw new GetAgencyByNameException(e);
        }
    }

    public Company getCompanyById(DfpSession session, Long companyId) throws GetCompanyByIdException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            StatementBuilder statementBuilder = new StatementBuilder().where("id = :id").withBindVariableValue("id", (Object)companyId);
            Company company = null;
            CompanyPage page = companyService.getCompaniesByStatement(statementBuilder.toStatement());
            if (page.getResults() != null) {
                company = page.getResults(0);
                logger.info((Object)("Company with ID " + company.getId() + " , name " + company.getName() + " type " + company.getType() + " was found."));
            }
            return company;
        }
        catch (ApiException e) {
            throw new GetCompanyByIdException(e);
        }
        catch (RemoteException e) {
            throw new GetCompanyByIdException(e);
        }
        catch (Exception e) {
            throw new GetCompanyByIdException(e);
        }
    }

    public Company createCompany(DfpSession session, Company company) throws CreateFailedException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            Company[] companies = companyService.createCompanies(new Company[]{company});
            Company createdCompany = companies[0];
            logger.info((Object)String.format("A company with ID \"%d\", name \"%s\", and type \"%s\" was created.\"%n\"", createdCompany.getId(), createdCompany.getName(), createdCompany.getType()));
            return createdCompany;
        }
        catch (ApiException e) {
            throw new CreateFailedException(e);
        }
        catch (RemoteException e) {
            throw new CreateFailedException(e);
        }
        catch (Exception e) {
            throw new CreateFailedException(e);
        }
    }

    public Company updateCompany(DfpSession session, Company company) throws UpdateFailedException {
        try {
            CompanyServiceInterface companyService = this.createCompanyService(session);
            Company[] companies = companyService.updateCompanies(new Company[]{company});
            Company updatedCompany = companies[0];
            logger.info((Object)String.format("Company with ID \"%d\", name \"%s\", and comment \"%s\" was updated.\"%n\"", updatedCompany.getId(), updatedCompany.getName(), updatedCompany.getComment()));
            return updatedCompany;
        }
        catch (ApiException e) {
            throw new UpdateFailedException(e);
        }
        catch (RemoteException e) {
            throw new UpdateFailedException(e);
        }
        catch (Exception e) {
            throw new UpdateFailedException(e);
        }
    }
}

