/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.connectivity;

import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.6.1.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.6.1.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.google.dfp.adapters.GoogleDfpConnectorConnectionManagementAdapter;
import org.mule.modules.google.dfp.connectivity.ConnectionManagementConfigGoogleDfpConnectorConnectionKey;
import org.mule.modules.google.dfp.connectivity.GoogleDfpConnectionStrategyGoogleDfpConnectorAdapter;
import org.mule.modules.google.dfp.pooling.DevkitGenericKeyedObjectPool;
import org.mule.modules.google.dfp.strategy.GoogleDfpConnectionStrategy;

public class GoogleDfpConnectorConfigConnectionManagementConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<GoogleDfpConnectorConnectionManagementAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectionManagementConnectionManager<ConnectionManagementConfigGoogleDfpConnectorConnectionKey, GoogleDfpConnectorConnectionManagementAdapter, GoogleDfpConnectionStrategy> {
    private String clientId;
    private String clientSecret;
    private List<String> customIds;
    private String refreshToken;
    private String tokenServerUrl;
    private String applicationName;
    private String endpoint;
    private String networkCode;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "GoogleDfp";
    private static final String MODULE_VERSION = "1.0.0";
    private static final String DEVKIT_VERSION = "3.6.1";
    private static final String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private static final String MIN_MULE_VERSION = "3.5.0";

    public void setClientSecret(String value) {
        this.clientSecret = value;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientId(String value) {
        this.clientId = value;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setCustomIds(List<String> value) {
        this.customIds = value;
    }

    public List<String> getCustomIds() {
        return this.customIds;
    }

    public void setRefreshToken(String value) {
        this.refreshToken = value;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setTokenServerUrl(String value) {
        this.tokenServerUrl = value;
    }

    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    public void setApplicationName(String value) {
        this.applicationName = value;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setEndpoint(String value) {
        this.endpoint = value;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setNetworkCode(String value) {
        this.networkCode = value;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public GoogleDfpConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigGoogleDfpConnectorConnectionKey key) throws Exception {
        return (GoogleDfpConnectorConnectionManagementAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ConnectionManagementConfigGoogleDfpConnectorConnectionKey key, GoogleDfpConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ConnectionManagementConfigGoogleDfpConnectorConnectionKey key, GoogleDfpConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, GoogleDfpConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public ConnectionManagementConfigGoogleDfpConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigGoogleDfpConnectorConnectionKey(this.getClientId(), this.getClientSecret());
    }

    @Override
    public ConnectionManagementConfigGoogleDfpConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedClientId = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("clientId").getGenericType(), null, this.getClientId());
            if (_transformedClientId == null) {
                throw new UnableToAcquireConnectionException("Parameter clientId in method connect can't be null because is not @Optional");
            }
            String _transformedClientSecret = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("clientSecret").getGenericType(), null, this.getClientSecret());
            if (_transformedClientSecret == null) {
                throw new UnableToAcquireConnectionException("Parameter clientSecret in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigGoogleDfpConnectorConnectionKey(_transformedClientId, _transformedClientSecret);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigGoogleDfpConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return this.getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        GoogleDfpConnectionStrategyGoogleDfpConnectorAdapter connection = new GoogleDfpConnectionStrategyGoogleDfpConnectorAdapter();
        connection.setRefreshToken(this.getRefreshToken());
        connection.setTokenServerUrl(this.getTokenServerUrl());
        connection.setApplicationName(this.getApplicationName());
        connection.setEndpoint(this.getEndpoint());
        connection.setNetworkCode(this.getNetworkCode());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<GoogleDfpConnectionStrategy, ConnectionManagementConfigGoogleDfpConnectorConnectionKey> connection) {
        GoogleDfpConnectorConnectionManagementAdapter connector = new GoogleDfpConnectorConnectionManagementAdapter();
        connector.setConnectionStrategy(connection.getStrategy());
        connector.setCustomIds(this.getCustomIds());
        return connector;
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        GoogleDfpConnectorConnectionManagementAdapter connector = (GoogleDfpConnectorConnectionManagementAdapter)adapter;
        ConnectionManagementConnectionAdapter strategy = (ConnectionManagementConnectionAdapter)((Object)connector.getConnectionStrategy());
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        GoogleDfpConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigGoogleDfpConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }
}

