/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.config;

import com.google.api.ads.dfp.axis.v201411.holders.DateExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.ReportJobExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.ReportQueryExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.StatementExpressionHolder;
import org.mule.config.MuleManifest;
import org.mule.modules.google.dfp.processors.DownloadReportMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DownloadReportDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(DownloadReportDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)DownloadReportMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [download-report] within the connector [google-dfp] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [download-report] within the connector [google-dfp] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"downloadReport");
        builder.setScope("prototype");
        if (!this.hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [download-report] within the connector [google-dfp] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "report-job", "reportJob", "#[payload]")) {
            BeanDefinitionBuilder reportJobBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)ReportJobExpressionHolder.class.getName());
            Element reportJobChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"report-job");
            if (reportJobChildElement != null) {
                this.parseProperty(reportJobBuilder, reportJobChildElement, "id", "id");
                if (!this.parseObjectRef(reportJobChildElement, reportJobBuilder, "report-query", "reportQuery")) {
                    BeanDefinitionBuilder _reportQueryBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)ReportQueryExpressionHolder.class.getName());
                    Element _reportQueryChildElement = DomUtils.getChildElementByTagName((Element)reportJobChildElement, (String)"report-query");
                    if (_reportQueryChildElement != null) {
                        if (this.hasAttribute(_reportQueryChildElement, "dimensions-ref")) {
                            if (_reportQueryChildElement.getAttribute("dimensions-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dimensions", (Object)_reportQueryChildElement.getAttribute("dimensions-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dimensions", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("dimensions-ref") + "]"));
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "adUnitView-ref")) {
                            if (_reportQueryChildElement.getAttribute("adUnitView-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("adUnitView", (Object)_reportQueryChildElement.getAttribute("adUnitView-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("adUnitView", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("adUnitView-ref") + "]"));
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "columns-ref")) {
                            if (_reportQueryChildElement.getAttribute("columns-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("columns", (Object)_reportQueryChildElement.getAttribute("columns-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("columns", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("columns-ref") + "]"));
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "dimensionAttributes-ref")) {
                            if (_reportQueryChildElement.getAttribute("dimensionAttributes-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dimensionAttributes", (Object)_reportQueryChildElement.getAttribute("dimensionAttributes-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dimensionAttributes", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("dimensionAttributes-ref") + "]"));
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "customFieldIds-ref")) {
                            if (_reportQueryChildElement.getAttribute("customFieldIds-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("customFieldIds", (Object)_reportQueryChildElement.getAttribute("customFieldIds-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("customFieldIds", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("customFieldIds-ref") + "]"));
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "contentMetadataKeyHierarchyCustomTargetingKeyIds-ref")) {
                            if (_reportQueryChildElement.getAttribute("contentMetadataKeyHierarchyCustomTargetingKeyIds-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("contentMetadataKeyHierarchyCustomTargetingKeyIds", (Object)_reportQueryChildElement.getAttribute("contentMetadataKeyHierarchyCustomTargetingKeyIds-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("contentMetadataKeyHierarchyCustomTargetingKeyIds", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("contentMetadataKeyHierarchyCustomTargetingKeyIds-ref") + "]"));
                            }
                        }
                        if (!this.parseObjectRef(_reportQueryChildElement, _reportQueryBuilder, "start-date", "startDate")) {
                            BeanDefinitionBuilder __startDateBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)DateExpressionHolder.class.getName());
                            Element __startDateChildElement = DomUtils.getChildElementByTagName((Element)_reportQueryChildElement, (String)"start-date");
                            if (__startDateChildElement != null) {
                                this.parseProperty(__startDateBuilder, __startDateChildElement, "year", "year");
                                this.parseProperty(__startDateBuilder, __startDateChildElement, "month", "month");
                                this.parseProperty(__startDateBuilder, __startDateChildElement, "day", "day");
                                _reportQueryBuilder.addPropertyValue("startDate", (Object)__startDateBuilder.getBeanDefinition());
                            }
                        }
                        if (!this.parseObjectRef(_reportQueryChildElement, _reportQueryBuilder, "end-date", "endDate")) {
                            BeanDefinitionBuilder __endDateBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)DateExpressionHolder.class.getName());
                            Element __endDateChildElement = DomUtils.getChildElementByTagName((Element)_reportQueryChildElement, (String)"end-date");
                            if (__endDateChildElement != null) {
                                this.parseProperty(__endDateBuilder, __endDateChildElement, "year", "year");
                                this.parseProperty(__endDateBuilder, __endDateChildElement, "month", "month");
                                this.parseProperty(__endDateBuilder, __endDateChildElement, "day", "day");
                                _reportQueryBuilder.addPropertyValue("endDate", (Object)__endDateBuilder.getBeanDefinition());
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "dateRangeType-ref")) {
                            if (_reportQueryChildElement.getAttribute("dateRangeType-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dateRangeType", (Object)_reportQueryChildElement.getAttribute("dateRangeType-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dateRangeType", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("dateRangeType-ref") + "]"));
                            }
                        }
                        if (this.hasAttribute(_reportQueryChildElement, "dimensionFilters-ref")) {
                            if (_reportQueryChildElement.getAttribute("dimensionFilters-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dimensionFilters", (Object)_reportQueryChildElement.getAttribute("dimensionFilters-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dimensionFilters", (Object)("#[registry:" + _reportQueryChildElement.getAttribute("dimensionFilters-ref") + "]"));
                            }
                        }
                        if (!this.parseObjectRef(_reportQueryChildElement, _reportQueryBuilder, "statement", "statement")) {
                            BeanDefinitionBuilder __statementBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)StatementExpressionHolder.class.getName());
                            Element __statementChildElement = DomUtils.getChildElementByTagName((Element)_reportQueryChildElement, (String)"statement");
                            if (__statementChildElement != null) {
                                this.parseProperty(__statementBuilder, __statementChildElement, "query", "query");
                                if (this.hasAttribute(__statementChildElement, "values-ref")) {
                                    if (__statementChildElement.getAttribute("values-ref").startsWith("#")) {
                                        __statementBuilder.addPropertyValue("values", (Object)__statementChildElement.getAttribute("values-ref"));
                                    } else {
                                        __statementBuilder.addPropertyValue("values", (Object)("#[registry:" + __statementChildElement.getAttribute("values-ref") + "]"));
                                    }
                                }
                                _reportQueryBuilder.addPropertyValue("statement", (Object)__statementBuilder.getBeanDefinition());
                            }
                        }
                        this.parseProperty(_reportQueryBuilder, _reportQueryChildElement, "timeZone", "timeZone");
                        reportJobBuilder.addPropertyValue("reportQuery", (Object)_reportQueryBuilder.getBeanDefinition());
                    }
                }
                if (this.hasAttribute(reportJobChildElement, "reportJobStatus-ref")) {
                    if (reportJobChildElement.getAttribute("reportJobStatus-ref").startsWith("#")) {
                        reportJobBuilder.addPropertyValue("reportJobStatus", (Object)reportJobChildElement.getAttribute("reportJobStatus-ref"));
                    } else {
                        reportJobBuilder.addPropertyValue("reportJobStatus", (Object)("#[registry:" + reportJobChildElement.getAttribute("reportJobStatus-ref") + "]"));
                    }
                }
                builder.addPropertyValue("reportJob", (Object)reportJobBuilder.getBeanDefinition());
            }
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

