/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp.config;

import com.google.api.ads.dfp.axis.v201411.holders.CompanyExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.DateExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.DateTimeExpressionHolder;
import org.mule.config.MuleManifest;
import org.mule.modules.google.dfp.processors.CreateCompanyMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateCompanyDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(CreateCompanyDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)CreateCompanyMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [create-company] within the connector [google-dfp] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [create-company] within the connector [google-dfp] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"createCompany");
        builder.setScope("prototype");
        if (!this.hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [create-company] within the connector [google-dfp] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        this.parseConfigRef(element, builder);
        if (!this.parseObjectRefWithDefault(element, builder, "company", "company", "#[payload]")) {
            BeanDefinitionBuilder companyBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)CompanyExpressionHolder.class.getName());
            Element companyChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"company");
            if (companyChildElement != null) {
                this.parseProperty(companyBuilder, companyChildElement, "id", "id");
                this.parseProperty(companyBuilder, companyChildElement, "name", "name");
                if (this.hasAttribute(companyChildElement, "type-ref")) {
                    if (companyChildElement.getAttribute("type-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("type", (Object)companyChildElement.getAttribute("type-ref"));
                    } else {
                        companyBuilder.addPropertyValue("type", (Object)("#[registry:" + companyChildElement.getAttribute("type-ref") + "]"));
                    }
                }
                this.parseProperty(companyBuilder, companyChildElement, "address", "address");
                this.parseProperty(companyBuilder, companyChildElement, "email", "email");
                this.parseProperty(companyBuilder, companyChildElement, "faxPhone", "faxPhone");
                this.parseProperty(companyBuilder, companyChildElement, "primaryPhone", "primaryPhone");
                this.parseProperty(companyBuilder, companyChildElement, "externalId", "externalId");
                this.parseProperty(companyBuilder, companyChildElement, "comment", "comment");
                if (this.hasAttribute(companyChildElement, "creditStatus-ref")) {
                    if (companyChildElement.getAttribute("creditStatus-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("creditStatus", (Object)companyChildElement.getAttribute("creditStatus-ref"));
                    } else {
                        companyBuilder.addPropertyValue("creditStatus", (Object)("#[registry:" + companyChildElement.getAttribute("creditStatus-ref") + "]"));
                    }
                }
                if (this.hasAttribute(companyChildElement, "appliedLabels-ref")) {
                    if (companyChildElement.getAttribute("appliedLabels-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("appliedLabels", (Object)companyChildElement.getAttribute("appliedLabels-ref"));
                    } else {
                        companyBuilder.addPropertyValue("appliedLabels", (Object)("#[registry:" + companyChildElement.getAttribute("appliedLabels-ref") + "]"));
                    }
                }
                this.parseProperty(companyBuilder, companyChildElement, "enableSameAdvertiserCompetitiveExclusion", "enableSameAdvertiserCompetitiveExclusion");
                this.parseProperty(companyBuilder, companyChildElement, "primaryContactId", "primaryContactId");
                if (this.hasAttribute(companyChildElement, "appliedTeamIds-ref")) {
                    if (companyChildElement.getAttribute("appliedTeamIds-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("appliedTeamIds", (Object)companyChildElement.getAttribute("appliedTeamIds-ref"));
                    } else {
                        companyBuilder.addPropertyValue("appliedTeamIds", (Object)("#[registry:" + companyChildElement.getAttribute("appliedTeamIds-ref") + "]"));
                    }
                }
                this.parseProperty(companyBuilder, companyChildElement, "thirdPartyCompanyId", "thirdPartyCompanyId");
                if (!this.parseObjectRef(companyChildElement, companyBuilder, "last-modified-date-time", "lastModifiedDateTime")) {
                    BeanDefinitionBuilder _lastModifiedDateTimeBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)DateTimeExpressionHolder.class.getName());
                    Element _lastModifiedDateTimeChildElement = DomUtils.getChildElementByTagName((Element)companyChildElement, (String)"last-modified-date-time");
                    if (_lastModifiedDateTimeChildElement != null) {
                        if (!this.parseObjectRef(_lastModifiedDateTimeChildElement, _lastModifiedDateTimeBuilder, "date", "date")) {
                            BeanDefinitionBuilder __dateBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)DateExpressionHolder.class.getName());
                            Element __dateChildElement = DomUtils.getChildElementByTagName((Element)_lastModifiedDateTimeChildElement, (String)"date");
                            if (__dateChildElement != null) {
                                this.parseProperty(__dateBuilder, __dateChildElement, "year", "year");
                                this.parseProperty(__dateBuilder, __dateChildElement, "month", "month");
                                this.parseProperty(__dateBuilder, __dateChildElement, "day", "day");
                                _lastModifiedDateTimeBuilder.addPropertyValue("date", (Object)__dateBuilder.getBeanDefinition());
                            }
                        }
                        this.parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "hour", "hour");
                        this.parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "minute", "minute");
                        this.parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "second", "second");
                        this.parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "timeZoneID", "timeZoneID");
                        companyBuilder.addPropertyValue("lastModifiedDateTime", (Object)_lastModifiedDateTimeBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("company", (Object)companyBuilder.getBeanDefinition());
            }
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

