/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.dfp;

import com.google.api.ads.dfp.axis.v201411.Company;
import com.google.api.ads.dfp.axis.v201411.Date;
import com.google.api.ads.dfp.axis.v201411.ReconciliationReportRow;
import com.google.api.ads.dfp.axis.v201411.ReportJob;
import com.google.api.ads.dfp.lib.client.DfpSession;
import java.io.InputStream;
import java.util.List;
import javax.annotation.PostConstruct;
import org.mule.modules.google.dfp.exceptions.CreateFailedException;
import org.mule.modules.google.dfp.exceptions.CreateReportException;
import org.mule.modules.google.dfp.exceptions.GetAdvertiserByNameException;
import org.mule.modules.google.dfp.exceptions.GetAgencyByNameException;
import org.mule.modules.google.dfp.exceptions.GetAllCompaniesException;
import org.mule.modules.google.dfp.exceptions.GetCompanyByIdException;
import org.mule.modules.google.dfp.exceptions.ReconciliationReportByIdException;
import org.mule.modules.google.dfp.exceptions.ReconciliationReportRowException;
import org.mule.modules.google.dfp.exceptions.ReportDownloadException;
import org.mule.modules.google.dfp.exceptions.TooManyAdvertisersFoundException;
import org.mule.modules.google.dfp.exceptions.TooManyAgenciesFoundException;
import org.mule.modules.google.dfp.exceptions.UpdateFailedException;
import org.mule.modules.google.dfp.reconciliationreport.ReconciliationQueryParams;
import org.mule.modules.google.dfp.services.CompanyService;
import org.mule.modules.google.dfp.services.ReconciliationReportRowService;
import org.mule.modules.google.dfp.services.ReconciliationReportService;
import org.mule.modules.google.dfp.services.ReportService;
import org.mule.modules.google.dfp.strategy.GoogleDfpConnectionStrategy;

public class GoogleDfpConnector {
    GoogleDfpConnectionStrategy connectionStrategy;
    private DfpSession session;
    private ReportService reportService;
    private CompanyService companyService;
    private ReconciliationReportService reconciliationReportService;
    private ReconciliationReportRowService reconciliationReportRowService;
    private List<String> customIds;

    @PostConstruct
    public void init() {
        this.session = this.connectionStrategy.getSession();
    }

    public void initialiseAndConfigureServices() {
        this.reportService = new ReportService();
        if (this.customIds != null && !this.customIds.isEmpty()) {
            long[] customFieldIds = new long[this.customIds.size()];
            for (int i = 0; i < this.customIds.size(); ++i) {
                customFieldIds[i] = Long.parseLong(this.customIds.get(i));
            }
            this.reportService.setCustomFieldsIds(customFieldIds);
        }
        this.companyService = new CompanyService();
        this.reconciliationReportService = new ReconciliationReportService();
        this.reconciliationReportRowService = new ReconciliationReportRowService();
    }

    public ReportJob createReport(Date startDate, Date endDate) throws CreateReportException {
        return this.reportService.createReport(this.session, startDate, endDate);
    }

    public InputStream downloadReport(ReportJob reportJob) throws ReportDownloadException {
        return this.reportService.downloadReport(this.session, reportJob);
    }

    public List<Company> getAllCompanies() throws GetAllCompaniesException {
        return this.companyService.getAllCompanies(this.session);
    }

    public Company getAgencyByName(String agencyName) throws GetAgencyByNameException, TooManyAgenciesFoundException {
        return this.companyService.getAgencyByName(this.session, agencyName);
    }

    public String getAdvertiserByName(String advertiserName) throws GetAdvertiserByNameException, TooManyAdvertisersFoundException {
        return this.companyService.getAdvertiserByName(this.session, advertiserName);
    }

    public List<Long> getReconciliationReportIdsByStartDate(Date startDate) throws ReconciliationReportByIdException {
        try {
            String dateFormat = "%04d-%02d-%02d";
            String stringDate = String.format(dateFormat, startDate.getYear(), startDate.getMonth(), startDate.getDay());
            return this.reconciliationReportService.getReconciliationReportIdsByStartDate(this.session, stringDate);
        }
        catch (Exception e) {
            throw new ReconciliationReportByIdException(e);
        }
    }

    public List<ReconciliationReportRow> getReconciliationReportRows(ReconciliationQueryParams queryParams) throws ReconciliationReportRowException {
        try {
            return this.reconciliationReportRowService.getReconciliationReportRows(this.session, queryParams);
        }
        catch (Exception e) {
            throw new ReconciliationReportRowException(e);
        }
    }

    public Company getCompanyById(Long companyId) throws GetCompanyByIdException {
        return this.companyService.getCompanyById(this.session, companyId);
    }

    public Company createCompany(Company company) throws CreateFailedException {
        return this.companyService.createCompany(this.session, company);
    }

    public Company updateCompany(Company company) throws UpdateFailedException {
        return this.companyService.updateCompany(this.session, company);
    }

    public GoogleDfpConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(GoogleDfpConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public List<String> getCustomIds() {
        return this.customIds;
    }

    public void setCustomIds(List<String> customIds) {
        this.customIds = customIds;
    }
}

