
package org.mule.modules.google.dfp.connectivity;

import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.modules.google.dfp.GoogleDfpConnector;
import org.mule.modules.google.dfp.adapters.GoogleDfpConnectorConnectionManagementAdapter;
import org.mule.modules.google.dfp.pooling.DevkitGenericKeyedObjectPool;
import org.mule.modules.google.dfp.strategy.GoogleDfpConnectionStrategy;


/**
 * A {@code GoogleDfpConnectorConfigConnectionManagementConnectionManager} is a wrapper around {@link GoogleDfpConnector } that adds connection management capabilities to the pojo.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-05-21T11:09:02-07:00", comments = "Build UNNAMED.2405.44720b7")
public class GoogleDfpConnectorConfigConnectionManagementConnectionManager
    extends ExpressionEvaluatorSupport
    implements MetadataAware, MuleContextAware, ProcessAdapter<GoogleDfpConnectorConnectionManagementAdapter> , Capabilities, Disposable, Initialisable, Testable, ConnectionManagementConnectionManager<ConnectionManagementConfigGoogleDfpConnectorConnectionKey, GoogleDfpConnectorConnectionManagementAdapter, GoogleDfpConnectionStrategy>
{

    /**
     * 
     */
    private String clientId;
    /**
     * 
     */
    private String clientSecret;
    private List<String> customIds;
    private String refreshToken;
    private String tokenServerUrl;
    private String applicationName;
    private String endpoint;
    private String networkCode;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Connector Pool
     * 
     */
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "GoogleDfp";
    private final static String MODULE_VERSION = "1.0.0";
    private final static String DEVKIT_VERSION = "3.6.1";
    private final static String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private final static String MIN_MULE_VERSION = "3.5.0";

    /**
     * Sets clientSecret
     * 
     * @param value Value to set
     */
    public void setClientSecret(String value) {
        this.clientSecret = value;
    }

    /**
     * Retrieves clientSecret
     * 
     */
    public String getClientSecret() {
        return this.clientSecret;
    }

    /**
     * Sets clientId
     * 
     * @param value Value to set
     */
    public void setClientId(String value) {
        this.clientId = value;
    }

    /**
     * Retrieves clientId
     * 
     */
    public String getClientId() {
        return this.clientId;
    }

    /**
     * Sets customIds
     * 
     * @param value Value to set
     */
    public void setCustomIds(List<String> value) {
        this.customIds = value;
    }

    /**
     * Retrieves customIds
     * 
     */
    public List<String> getCustomIds() {
        return this.customIds;
    }

    /**
     * Sets refreshToken
     * 
     * @param value Value to set
     */
    public void setRefreshToken(String value) {
        this.refreshToken = value;
    }

    /**
     * Retrieves refreshToken
     * 
     */
    public String getRefreshToken() {
        return this.refreshToken;
    }

    /**
     * Sets tokenServerUrl
     * 
     * @param value Value to set
     */
    public void setTokenServerUrl(String value) {
        this.tokenServerUrl = value;
    }

    /**
     * Retrieves tokenServerUrl
     * 
     */
    public String getTokenServerUrl() {
        return this.tokenServerUrl;
    }

    /**
     * Sets applicationName
     * 
     * @param value Value to set
     */
    public void setApplicationName(String value) {
        this.applicationName = value;
    }

    /**
     * Retrieves applicationName
     * 
     */
    public String getApplicationName() {
        return this.applicationName;
    }

    /**
     * Sets endpoint
     * 
     * @param value Value to set
     */
    public void setEndpoint(String value) {
        this.endpoint = value;
    }

    /**
     * Retrieves endpoint
     * 
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Sets networkCode
     * 
     * @param value Value to set
     */
    public void setNetworkCode(String value) {
        this.networkCode = value;
    }

    /**
     * Retrieves networkCode
     * 
     */
    public String getNetworkCode() {
        return this.networkCode;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets poolingProfile
     * 
     * @param value Value to set
     */
    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    /**
     * Retrieves poolingProfile
     * 
     */
    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), poolingProfile);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    @Override
    public void dispose() {
        try {
            connectionPool.close();
        } catch (Exception e) {
        }
    }

    public GoogleDfpConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigGoogleDfpConnectorConnectionKey key)
        throws Exception
    {
        return ((GoogleDfpConnectorConnectionManagementAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(ConnectionManagementConfigGoogleDfpConnectorConnectionKey key, GoogleDfpConnectorConnectionManagementAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(ConnectionManagementConfigGoogleDfpConnectorConnectionKey key, GoogleDfpConnectorConnectionManagementAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, GoogleDfpConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, muleContext);
    }

    @Override
    public ConnectionManagementConfigGoogleDfpConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigGoogleDfpConnectorConnectionKey(getClientId(), getClientSecret());
    }

    @Override
    public ConnectionManagementConfigGoogleDfpConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event)
        throws Exception
    {
        if (event!= null) {
            final String _transformedClientId = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("clientId").getGenericType(), null, getClientId()));
            if (_transformedClientId == null) {
                throw new UnableToAcquireConnectionException("Parameter clientId in method connect can't be null because is not @Optional");
            }
            final String _transformedClientSecret = ((String) evaluateAndTransform(muleContext, event, this.getClass().getDeclaredField("clientSecret").getGenericType(), null, getClientSecret()));
            if (_transformedClientSecret == null) {
                throw new UnableToAcquireConnectionException("Parameter clientSecret in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigGoogleDfpConnectorConnectionKey(_transformedClientId, _transformedClientSecret);
        }
        return getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigGoogleDfpConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event)
        throws Exception
    {
        return getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        GoogleDfpConnectionStrategyGoogleDfpConnectorAdapter connection = new GoogleDfpConnectionStrategyGoogleDfpConnectorAdapter();
        connection.setRefreshToken(getRefreshToken());
        connection.setTokenServerUrl(getTokenServerUrl());
        connection.setApplicationName(getApplicationName());
        connection.setEndpoint(getEndpoint());
        connection.setNetworkCode(getNetworkCode());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<GoogleDfpConnectionStrategy, ConnectionManagementConfigGoogleDfpConnectorConnectionKey> connection) {
        GoogleDfpConnectorConnectionManagementAdapter connector = new GoogleDfpConnectorConnectionManagementAdapter();
        connector.setConnectionStrategy(connection.getStrategy());
        connector.setCustomIds(getCustomIds());
        return connector;
    }

    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        GoogleDfpConnectorConnectionManagementAdapter connector = ((GoogleDfpConnectorConnectionManagementAdapter) adapter);
        ConnectionManagementConnectionAdapter strategy = ((ConnectionManagementConnectionAdapter) connector.getConnectionStrategy());
        return strategy;
    }

    public TestResult test() {
        GoogleDfpConnectorConnectionManagementAdapter connection = null;
        DefaultTestResult result;
        ConnectionManagementConfigGoogleDfpConnectorConnectionKey key = getDefaultConnectionKey();
        try {
            connection = acquireConnection(key);
            result = new DefaultTestResult(org.mule.common.Result.Status.SUCCESS);
        } catch (Exception e) {
            try {
                destroyConnection(key, connection);
            } catch (Exception ie) {
            }
            result = ((DefaultTestResult) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        } finally {
            if (connection!= null) {
                try {
                    releaseConnection(key, connection);
                } catch (Exception ie) {
                }
            }
        }
        return result;
    }

}
